/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.internal;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.annotations.FieldReference;
import com.zeitheron.hammercore.annotations.RegistryName;
import com.zeitheron.hammercore.annotations.SimplyRegister;
import com.zeitheron.hammercore.api.INoItemBlock;
import com.zeitheron.hammercore.api.ITileBlock;
import com.zeitheron.hammercore.api.blocks.IBlockItemRegisterListener;
import com.zeitheron.hammercore.api.blocks.INoBlockstate;
import com.zeitheron.hammercore.api.multipart.BlockMultipartProvider;
import com.zeitheron.hammercore.internal.SimpleRegistration;
import com.zeitheron.hammercore.internal.blocks.IItemBlock;
import com.zeitheron.hammercore.internal.init.ItemsHC;
import com.zeitheron.hammercore.utils.IRegisterListener;
import com.zeitheron.hammercore.utils.ReflectionUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.java.tuples.Tuple2;
import com.zeitheron.hammercore.utils.java.tuples.Tuples;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SimpleRegisterKernel {
    protected final String className;
    protected final ModContainer container;
    protected Map<Class<?>, List<Tuple2<IForgeRegistryEntry<?>, ResourceLocation>>> fields;
    protected CreativeTabs assignedTab;
    protected boolean registeredItems;
    protected boolean registeredBlocks;

    public SimpleRegisterKernel(String className, ModContainer container) {
        this.className = className;
        this.container = container;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Map<Class<?>, List<Tuple2<IForgeRegistryEntry<?>, ResourceLocation>>> getFields() {
        if (this.fields != null) {
            return this.fields;
        }
        this.fields = new HashMap();
        try {
            Class<?> ownerCls = Class.forName(this.className);
            String prefix = "";
            SimplyRegister sr = ownerCls.getAnnotation(SimplyRegister.class);
            if (sr != null) {
                prefix = sr.prefix();
                FieldReference tab = sr.creativeTab();
                this.assignedTab = Cast.cast(ReflectionUtil.getValue(tab.clazz(), tab.field()), CreativeTabs.class);
            }
            for (Field f : ownerCls.getDeclaredFields()) {
                if (!IForgeRegistryEntry.class.isAssignableFrom(f.getType()) || !Modifier.isStatic(f.getModifiers())) continue;
                if (!SimpleRegistration.doRegister(f)) {
                    HammerCore.LOG.debug("Skipped {} since @RegisterIf returned false.", (Object)f);
                    continue;
                }
                RegistryName key = f.getAnnotation(RegistryName.class);
                if (key == null) continue;
                f.setAccessible(true);
                IForgeRegistryEntry ctr = (IForgeRegistryEntry)Cast.cast(f.get(null));
                if (ctr == null) continue;
                ResourceLocation regKey = new ResourceLocation(this.container.getModId(), prefix + key.value());
                this.fields.computeIfAbsent(ctr.getRegistryType(), ignore -> new ArrayList()).add(Tuples.immutable(ctr, regKey));
            }
        }
        catch (Exception e) {
            HammerCore.LOG.error("Failed to register read class {}", (Object)this.className, (Object)e);
        }
        return this.fields;
    }

    public void registerItems() {
        this.register(new RegistryEvent.Register(GameData.ITEMS, ForgeRegistries.ITEMS));
    }

    public void registerBlocks() {
        this.register(new RegistryEvent.Register(GameData.BLOCKS, ForgeRegistries.BLOCKS));
    }

    @SubscribeEvent
    protected void register(RegistryEvent.Register evt) {
        IForgeRegistry reg = evt.getRegistry();
        Class base = reg.getRegistrySuperType();
        List<Tuple2<IForgeRegistryEntry<?>, ResourceLocation>> toRegister = this.getFields().get(base);
        if (toRegister == null || toRegister.isEmpty()) {
            return;
        }
        ModContainer old = Loader.instance().activeModContainer();
        Loader.instance().setActiveModContainer(this.container);
        evt.setModContainer(this.container);
        boolean blocks = base.equals(Block.class);
        boolean items = base.equals(Item.class);
        String modid = this.container.getModId();
        if (blocks && this.registeredBlocks) {
            return;
        }
        if (items && this.registeredItems) {
            return;
        }
        if (blocks) {
            this.registeredBlocks = true;
        }
        if (items) {
            this.registeredItems = true;
        }
        try {
            for (Tuple2<IForgeRegistryEntry<?>, ResourceLocation> tup : toRegister) {
                IForgeRegistryEntry<?> ctr = tup.a();
                ResourceLocation regKey = tup.b();
                ctr.setRegistryName(regKey);
                if (items) {
                    Cast.optionally(ctr, Item.class).ifPresent(it -> {
                        it.func_77655_b(regKey.func_110624_b().concat(":").concat(regKey.func_110623_a()));
                        if (this.assignedTab != null) {
                            it.func_77637_a(this.assignedTab);
                        }
                        ItemsHC.items.add((Item)it);
                    });
                } else if (blocks) {
                    Cast.optionally(ctr, Block.class).ifPresent(block -> {
                        Item i;
                        block.func_149663_c(regKey.func_110624_b().concat(":").concat(regKey.func_110623_a()));
                        if (this.assignedTab != null) {
                            block.func_149647_a(this.assignedTab);
                        }
                        Object ib = block instanceof BlockMultipartProvider ? ((BlockMultipartProvider)block).createItem() : (block instanceof IItemBlock ? ((IItemBlock)block).getItemBlock() : new ItemBlock(block));
                        if (!(block instanceof INoItemBlock)) {
                            if (ib != null) {
                                ForgeRegistries.ITEMS.register(ib.setRegistryName(block.getRegistryName()));
                                if (block instanceof IBlockItemRegisterListener) {
                                    ((IBlockItemRegisterListener)block).onItemBlockRegistered((Item)ib);
                                }
                            }
                            if (ib instanceof IRegisterListener) {
                                ((IRegisterListener)ib).onRegistered();
                            }
                        }
                        if (block instanceof INoBlockstate) {
                            HammerCore.renderProxy.noModel((Block)block);
                        }
                        if (block instanceof ITileBlock) {
                            Class c = ((ITileBlock)block).getTileClass();
                            TileEntity.func_190560_a((String)(modid + ":" + c.getSimpleName().toLowerCase()), c);
                        } else if (block instanceof ITileEntityProvider) {
                            try {
                                ITileEntityProvider te = (ITileEntityProvider)block;
                                TileEntity t = te.func_149915_a(null, 0);
                                if (t != null) {
                                    Class<?> c = t.getClass();
                                    TileEntity.func_190560_a((String)(modid + ":" + c.getSimpleName().toLowerCase()), c);
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                        if (!(block instanceof INoItemBlock) && (i = Item.func_150898_a((Block)block)) != Items.field_190931_a) {
                            ItemsHC.items.add(i);
                            if (this.assignedTab != null) {
                                i.func_77637_a(this.assignedTab);
                            }
                        }
                    });
                }
                reg.register((IForgeRegistryEntry)Cast.cast(ctr));
                if (ctr instanceof IRegisterListener) {
                    ((IRegisterListener)ctr).onRegistered();
                }
                HammerCore.LOG.debug("Registered {}: {} ({})", (Object)base.getSimpleName(), ctr, (Object)regKey);
            }
        }
        catch (Exception e) {
            HammerCore.LOG.error("Failed to register {} from class {}", (Object)base.getSimpleName(), (Object)this.className, (Object)e);
        }
        Loader.instance().setActiveModContainer(old);
    }

    public static List<SimpleRegisterKernel> doScan(ASMDataTable table) {
        ArrayList<SimpleRegisterKernel> kernels = new ArrayList<SimpleRegisterKernel>();
        for (ASMDataTable.ASMData data : table.getAll(SimplyRegister.class.getCanonicalName())) {
            ModContainer mod = data.getCandidate().getContainedMods().stream().findFirst().orElse(null);
            if (mod == null) {
                HammerCore.LOG.warn("Skipping @SimplyRegister-annotated class {} since it does not belong to any mod.", (Object)data.getClassName());
                continue;
            }
            kernels.add(new SimpleRegisterKernel(data.getClassName(), mod));
            HammerCore.LOG.info("Applied @SimplyRegister to {}, which belongs to {} ({})", (Object)data.getClassName(), (Object)mod.getModId(), (Object)mod.getName());
        }
        return kernels;
    }

    public boolean is(String modid) {
        return Objects.equals(this.container.getModId(), modid);
    }
}

