/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.items;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IRenderAwareItem {
    public static final Map<Item, IRenderAwareItem> overrides = new HashMap<Item, IRenderAwareItem>();

    public static void overrideRenderAwareness(Block block, IRenderAwareItem aware) {
        IRenderAwareItem.overrideRenderAwareness(Item.func_150898_a((Block)block), aware);
    }

    public static void appendRenderAwareness(Block block, IRenderAwareItem aware) {
        IRenderAwareItem.appendRenderAwareness(Item.func_150898_a((Block)block), aware);
    }

    public static void overrideRenderAwareness(Item item, IRenderAwareItem aware) {
        overrides.put(item, aware);
    }

    public static void appendRenderAwareness(Item item, IRenderAwareItem aware) {
        overrides.put(item, overrides.computeIfAbsent(item, i -> aware).and(aware));
    }

    public static IRenderAwareItem get(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item it = stack.func_77973_b();
        if (overrides.containsKey(it)) {
            return overrides.get(it);
        }
        if (it instanceof IRenderAwareItem) {
            return (IRenderAwareItem)it;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    default public void preRenderInGUI(ItemStack stack, int x, int y, IBakedModel model) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void postRenderInGUI(ItemStack stack, int x, int y, IBakedModel model) {
    }

    default public IRenderAwareItem and(final IRenderAwareItem secondary) {
        final IRenderAwareItem primary = this;
        if (primary == secondary) {
            return primary;
        }
        return new IRenderAwareItem(){

            @Override
            public void preRenderInGUI(ItemStack stack, int x, int y, IBakedModel model) {
                primary.preRenderInGUI(stack, x, y, model);
                secondary.preRenderInGUI(stack, x, y, model);
            }

            @Override
            public void postRenderInGUI(ItemStack stack, int x, int y, IBakedModel model) {
                primary.postRenderInGUI(stack, x, y, model);
                secondary.postRenderInGUI(stack, x, y, model);
            }
        };
    }
}

