/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Property;

class FloatValue
extends AbstractValue<Float> {
    protected FloatValue(IValueFactory owner, String section, String keyname, Float defaultValue, String text) {
        super(owner, section, keyname, defaultValue, text);
    }

    @Override
    @Nullable
    protected Float makeValue() {
        float min = this.minValue != null ? this.minValue.floatValue() : Float.NEGATIVE_INFINITY;
        float max = this.maxValue != null ? this.maxValue.floatValue() : Float.MAX_VALUE;
        Property prop = this.owner.getConfig().get(this.section, this.keyname, (double)((Float)this.defaultValue).floatValue());
        prop.setLanguageKey(this.keyname);
        prop.setComment(this.getText() + " [range: " + min + " ~ " + max + ", default: " + this.defaultValue + "]");
        prop.setMinValue((double)min);
        prop.setMaxValue((double)max);
        prop.setRequiresMcRestart(this.isStartup);
        return Float.valueOf((float)MathHelper.func_151237_a((double)prop.getDouble((double)((Float)this.defaultValue).floatValue()), (double)min, (double)max));
    }

    @Override
    protected IByteBufAdapter<Float> getDataType() {
        return ByteBufAdapters.FLOAT;
    }
}

