/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javapatcher.patcher;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;
import me.nallar.javapatcher.PatcherLog;
import me.nallar.javapatcher.mappings.ClassDescription;
import me.nallar.javapatcher.mappings.DefaultMappings;
import me.nallar.javapatcher.mappings.FieldDescription;
import me.nallar.javapatcher.mappings.Mappings;
import me.nallar.javapatcher.mappings.MethodDescription;
import me.nallar.javapatcher.patcher.CollectionsUtil;
import me.nallar.javapatcher.patcher.DomUtil;
import me.nallar.javapatcher.patcher.Patch;
import me.nallar.javapatcher.patcher.Patches;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Patcher {
    private static final String debugPatchedOutput = System.getProperty("patcher.debug", "");
    private static final Splitter idSplitter = Splitter.on((String)"  ").trimResults().omitEmptyStrings();
    private final ClassPool classPool;
    private final Mappings mappings;
    private final Map<String, PatchMethodDescriptor> patchMethods = new HashMap<String, PatchMethodDescriptor>();
    private final Multimap<String, ClassPatchDescriptor> patches = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<String, byte[]> patchedBytes = new HashMap<String, byte[]>();
    private Object patchClassInstance;

    public Patcher(ClassPool classPool) {
        this(classPool, Patches.class);
    }

    public Patcher(ClassPool classPool, Class<?> patchesClass) {
        this(classPool, patchesClass, new DefaultMappings());
    }

    public Patcher(ClassPool classPool, Class<?> patchesClass, Mappings mappings) {
        for (Method method : patchesClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                PatchMethodDescriptor patchMethodDescriptor;
                if (!(annotation instanceof Patch) || this.patchMethods.put(patchMethodDescriptor.name, patchMethodDescriptor = new PatchMethodDescriptor(method, (Patch)annotation)) == null) continue;
                PatcherLog.warn("Duplicate @Patch method with name " + patchMethodDescriptor.name);
            }
        }
        this.classPool = classPool;
        this.mappings = mappings;
        try {
            this.patchClassInstance = patchesClass.getDeclaredConstructors()[0].newInstance(classPool, mappings);
        }
        catch (Exception e) {
            PatcherLog.error("Failed to instantiate patch class", e);
        }
    }

    private static void saveByteCode(byte[] bytes, String name) {
        if (!debugPatchedOutput.isEmpty()) {
            name = name.replace('.', '/') + ".class";
            File file = new File(debugPatchedOutput + '/' + name);
            file.getParentFile().mkdirs();
            try {
                Files.write((byte[])bytes, (File)file);
            }
            catch (IOException e) {
                PatcherLog.error("Failed to save patched bytes for " + name, e);
            }
        }
    }

    public void loadPatches(InputStream inputStream) {
        this.loadPatches(DomUtil.readInputStreamToString(inputStream));
    }

    public void loadPatches(String patch) {
        switch (patch.charAt(0)) {
            case '<': {
                this.readPatchesFromXmlString(patch);
                break;
            }
            case '[': 
            case '{': {
                this.readPatchesFromJsonString(patch);
                break;
            }
            default: {
                throw new RuntimeException("Unknown patch format for " + patch);
            }
        }
    }

    @Deprecated
    public void readPatchesFromXmlInputStream(InputStream inputStream) {
        this.readPatchesFromXmlString(DomUtil.readInputStreamToString(inputStream));
    }

    @Deprecated
    public void readPatchesFromJsonInputStream(InputStream inputStream) {
        this.readPatchesFromJsonString(DomUtil.readInputStreamToString(inputStream));
    }

    private void readPatchesFromJsonString(String json) {
        this.readPatchesFromXmlString(DomUtil.makePatchXmlFromJson(json));
    }

    private void readPatchesFromXmlString(String document) {
        try {
            this.readPatchesFromXmlDocument(DomUtil.readDocumentFromString(document));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public void readPatchesFromXmlDocument(Document document) {
        List<Element> patchGroupElements = DomUtil.children(document.getDocumentElement());
        for (Element patchGroupElement : patchGroupElements) {
            this.loadPatchGroup(patchGroupElement);
        }
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public boolean willPatch(String className) {
        return !this.patches.get((Object)className).isEmpty();
    }

    public byte[] patch(String className) {
        return this.patch(className, null);
    }

    public synchronized byte[] patch(String className, byte[] originalBytes) {
        byte[] bytes = this.patchedBytes.get(className);
        if (bytes != null) {
            return bytes;
        }
        Collection patches = this.patches.get((Object)className);
        if (patches.isEmpty()) {
            return originalBytes;
        }
        try {
            CtClass ctClass = this.classPool.get(className);
            for (ClassPatchDescriptor classPatchDescriptor : patches) {
                ctClass = classPatchDescriptor.runPatches(ctClass);
            }
            bytes = ctClass.toBytecode();
            this.patchedBytes.put(className, bytes);
            Patcher.saveByteCode(bytes, className);
            return bytes;
        }
        catch (Throwable t) {
            PatcherLog.error("Failed to patch " + className + " in patch group " + className + '.', t);
            return originalBytes;
        }
    }

    private void obfuscateAttributesAndTextContent(Element root) {
        for (Element element : DomUtil.children(root)) {
            if (!DomUtil.children(element).isEmpty()) {
                this.obfuscateAttributesAndTextContent(element);
            } else if (element.getTextContent() != null && !element.getTextContent().isEmpty()) {
                element.setTextContent(this.mappings.obfuscate(element.getTextContent()));
            }
            Map<String, String> attributes = DomUtil.getAttributes(element);
            for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
                element.setAttribute(attributeEntry.getKey(), this.mappings.obfuscate(attributeEntry.getValue()));
            }
        }
        for (Element element : DomUtil.children(root)) {
            String id = element.getAttribute("id");
            ArrayList list = Lists.newArrayList((Iterable)idSplitter.split((CharSequence)id));
            if (list.size() <= 1) continue;
            for (String className : list) {
                Element newClassElement = (Element)element.cloneNode(true);
                newClassElement.setAttribute("id", className.trim());
                element.getParentNode().insertBefore(newClassElement, element);
            }
            element.getParentNode().removeChild(element);
        }
    }

    private void loadPatchGroup(Element e) {
        Map<String, String> attributes = DomUtil.getAttributes(e);
        String requiredProperty = attributes.get("requireProperty");
        if (requiredProperty != null && !requiredProperty.isEmpty() && !Boolean.getBoolean(requiredProperty)) {
            return;
        }
        this.obfuscateAttributesAndTextContent(e);
        List<Element> patchElements = DomUtil.children(e);
        for (Element classElement : patchElements) {
            ClassPatchDescriptor classPatchDescriptor;
            try {
                classPatchDescriptor = new ClassPatchDescriptor(classElement);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to create class patch for " + classElement.getAttribute("id"), t);
            }
            this.patches.put((Object)classPatchDescriptor.name, (Object)classPatchDescriptor);
            PatcherLog.info("Added patch " + e.getTagName() + ": " + classPatchDescriptor.toString());
        }
    }

    public class ClassPatchDescriptor {
        public final String name;
        public final List<PatchDescriptor> patches = new ArrayList<PatchDescriptor>();
        private final Map<String, String> attributes;

        private ClassPatchDescriptor(Element element) {
            this.attributes = DomUtil.getAttributes(element);
            ClassDescription deobfuscatedClass = new ClassDescription(this.attributes.get("id"));
            ClassDescription obfuscatedClass = Patcher.this.mappings.map(deobfuscatedClass);
            this.name = obfuscatedClass == null ? deobfuscatedClass.name : obfuscatedClass.name;
            for (Element patchElement : DomUtil.children(element)) {
                FieldDescription obfuscatedField;
                PatchDescriptor patchDescriptor = new PatchDescriptor(patchElement);
                this.patches.add(patchDescriptor);
                List<MethodDescription> methodDescriptionList = MethodDescription.fromListString(deobfuscatedClass.name, patchDescriptor.getMethods());
                if (!patchDescriptor.getMethods().isEmpty()) {
                    patchDescriptor.set("deobf", methodDescriptionList.get(0).getShortName());
                    patchDescriptor.setMethods(MethodDescription.toListString(Patcher.this.mappings.map(methodDescriptionList)));
                }
                String field = patchDescriptor.get("field");
                String prefix = "";
                if (field == null || field.isEmpty()) continue;
                if (field.startsWith("this.")) {
                    field = field.substring("this.".length());
                    prefix = "this.";
                }
                String after = "";
                String type = this.name;
                if (field.indexOf(46) != -1) {
                    after = field.substring(field.indexOf(46));
                    if (!(field = field.substring(0, field.indexOf(46))).isEmpty() && field.charAt(0) == '$' && prefix.isEmpty()) {
                        ArrayList<String> parameterList = new ArrayList<String>();
                        for (MethodDescription methodDescriptionOriginal : methodDescriptionList) {
                            MethodDescription methodDescription = Patcher.this.mappings.unmap(Patcher.this.mappings.map(methodDescriptionOriginal));
                            methodDescription = methodDescription == null ? methodDescriptionOriginal : methodDescription;
                            int i = 0;
                            for (String parameter : methodDescription.getParameterList()) {
                                if (parameterList.size() <= i) {
                                    parameterList.add(parameter);
                                } else if (!((String)parameterList.get(i)).equals(parameter)) {
                                    parameterList.set(i, null);
                                }
                                ++i;
                            }
                        }
                        int parameterIndex = Integer.valueOf(field.substring(1)) - 1;
                        if (parameterIndex >= parameterList.size()) {
                            if (parameterList.isEmpty()) break;
                            PatcherLog.error("Can not obfuscate parameter field " + patchDescriptor.get("field") + ", index: " + parameterIndex + " but parameter list is: " + Joiner.on((char)',').join(parameterList));
                            break;
                        }
                        type = (String)parameterList.get(parameterIndex);
                        if (type == null) {
                            PatcherLog.error("Can not obfuscate parameter field " + patchDescriptor.get("field") + " automatically as this parameter does not have a single type across the methods used in this patch.");
                            break;
                        }
                        prefix = field + '.';
                        field = after.substring(1);
                        after = "";
                    }
                }
                if ((obfuscatedField = Patcher.this.mappings.map(new FieldDescription(type, field))) == null) continue;
                patchDescriptor.set("field", prefix + obfuscatedField.name + after);
            }
        }

        public CtClass runPatches(CtClass ctClass) throws NotFoundException {
            for (PatchDescriptor patchDescriptor : this.patches) {
                PatchMethodDescriptor patchMethodDescriptor = (PatchMethodDescriptor)Patcher.this.patchMethods.get(patchDescriptor.getPatch());
                if (patchMethodDescriptor == null) {
                    PatcherLog.error("Couldn't find patch with name " + patchDescriptor.getPatch() + " when patching " + ctClass.getName());
                    return ctClass;
                }
                Object result = patchMethodDescriptor.run(patchDescriptor, ctClass, Patcher.this.patchClassInstance);
                if (!(result instanceof CtClass)) continue;
                ctClass = (CtClass)result;
            }
            return ctClass;
        }

        public String toString() {
            return "Patcher.ClassPatchDescriptor(name=" + this.name + ", patches=" + this.patches + ")";
        }
    }

    private static class PatchMethodDescriptor {
        public final String name;
        public final List<String> requiredAttributes;
        public final Method patchMethod;
        public final boolean isClassPatch;
        public final boolean emptyConstructor;

        private PatchMethodDescriptor(Method method, Patch patch) {
            String name = patch.name();
            this.requiredAttributes = Arrays.asList(method.getParameterTypes()).contains(Map.class) ? Lists.newArrayList((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)patch.requiredAttributes())) : null;
            if (name.isEmpty()) {
                name = method.getName();
            }
            this.name = name;
            this.emptyConstructor = patch.emptyConstructor();
            this.isClassPatch = method.getParameterTypes()[0].equals(CtClass.class);
            this.patchMethod = method;
        }

        public Object run(PatchDescriptor patchDescriptor, CtClass ctClass, Object patchClassInstance) {
            String methods = patchDescriptor.getMethods();
            Map<String, String> attributes = patchDescriptor.getAttributes();
            HashMap<String, String> attributesClean = new HashMap<String, String>(attributes);
            attributesClean.remove("code");
            PatcherLog.trace("Patching " + ctClass.getName() + " with " + this.name + '(' + CollectionsUtil.mapToString(attributesClean) + ')' + (methods.isEmpty() ? "" : " {" + methods + '}'));
            if (this.requiredAttributes != null && !this.requiredAttributes.isEmpty() && !attributes.keySet().containsAll(this.requiredAttributes)) {
                PatcherLog.error("Missing required attributes " + this.requiredAttributes.toString() + " when patching " + ctClass.getName());
                return null;
            }
            if ("^all^".equals(methods)) {
                patchDescriptor.set("silent", "true");
                ArrayList<CtConstructor> ctBehaviors = new ArrayList<CtConstructor>();
                Collections.addAll(ctBehaviors, ctClass.getDeclaredMethods());
                Collections.addAll(ctBehaviors, ctClass.getDeclaredConstructors());
                CtConstructor initializer = ctClass.getClassInitializer();
                if (initializer != null) {
                    ctBehaviors.add(initializer);
                }
                for (CtBehavior ctBehavior : ctBehaviors) {
                    this.run(ctBehavior, attributes, patchClassInstance);
                }
            } else {
                if (this.isClassPatch || !this.emptyConstructor && methods.isEmpty()) {
                    return this.run(ctClass, attributes, patchClassInstance);
                }
                if (methods.isEmpty()) {
                    for (CtConstructor ctConstructor : ctClass.getDeclaredConstructors()) {
                        this.run((CtBehavior)ctConstructor, attributes, patchClassInstance);
                    }
                } else if ("^static^".equals(methods)) {
                    CtConstructor ctBehavior = ctClass.getClassInitializer();
                    if (ctBehavior == null) {
                        PatcherLog.error("No static initializer found patching " + ctClass.getName() + " with " + this.toString());
                    } else {
                        this.run((CtBehavior)ctBehavior, attributes, patchClassInstance);
                    }
                } else {
                    List<MethodDescription> methodDescriptions = MethodDescription.fromListString(ctClass.getName(), methods);
                    for (MethodDescription methodDescription : methodDescriptions) {
                        CtBehavior ctBehavior;
                        try {
                            ctBehavior = methodDescription.inClass(ctClass);
                        }
                        catch (Throwable t) {
                            if (attributes.containsKey("allowMissing")) continue;
                            PatcherLog.warn("", t);
                            continue;
                        }
                        this.run(ctBehavior, attributes, patchClassInstance);
                    }
                }
            }
            return null;
        }

        private Object run(CtClass ctClass, Map<String, String> attributes, Object patchClassInstance) {
            try {
                if (this.requiredAttributes == null) {
                    return this.patchMethod.invoke(patchClassInstance, ctClass);
                }
                return this.patchMethod.invoke(patchClassInstance, ctClass, attributes);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if (t instanceof CannotCompileException && attributes.containsKey("code")) {
                    PatcherLog.error("Code: " + attributes.get("code"));
                }
                PatcherLog.error("Error patching " + ctClass.getName() + " with " + this.toString(), t);
                return null;
            }
        }

        private Object run(CtBehavior ctBehavior, Map<String, String> attributes, Object patchClassInstance) {
            try {
                if (this.requiredAttributes == null) {
                    return this.patchMethod.invoke(patchClassInstance, ctBehavior);
                }
                return this.patchMethod.invoke(patchClassInstance, ctBehavior, attributes);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = t.getCause();
                }
                if (t instanceof CannotCompileException && attributes.containsKey("code")) {
                    PatcherLog.error("Code: " + attributes.get("code"));
                }
                PatcherLog.error("Error patching " + ctBehavior.getName() + " in " + ctBehavior.getDeclaringClass().getName() + " with " + this.toString(), t);
                return null;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    private static class PatchDescriptor {
        private String methods;
        private final String patch;
        private final Map<String, String> attributes;

        PatchDescriptor(Element element) {
            this.attributes = DomUtil.getAttributes(element);
            this.methods = element.getTextContent().trim();
            this.patch = element.getTagName();
        }

        public String set(String name, String value) {
            return this.attributes.put(name, value);
        }

        public String get(String name) {
            return this.attributes.get(name);
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getMethods() {
            return this.methods;
        }

        public void setMethods(String methods) {
            this.methods = methods;
        }

        public String getPatch() {
            return this.patch;
        }

        public String toString() {
            return "Patcher.PatchDescriptor(methods=" + this.getMethods() + ", patch=" + this.getPatch() + ")";
        }
    }
}

