/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javapatcher.patcher;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.nallar.javapatcher.PatcherLog;
import me.nallar.javapatcher.patcher.Throw;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

enum DomUtil {

    private static final Pattern stringMatcher = Pattern.compile("\"\"\"(.*?)\"\"\"", 32);

    public static List<Element> children(Element parent) {
        List<Node> nodes = DomUtil.nodeList(parent.getChildNodes());
        ArrayList<Element> elements = new ArrayList<Element>(nodes.size());
        for (Node node : nodes) {
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        elements.trimToSize();
        return elements;
    }

    public static List<Node> nodeList(final NodeList nodeList) {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    public static Map<String, String> getAttributes(Node node) {
        NamedNodeMap attributeMap = node.getAttributes();
        HashMap<String, String> attributes = new HashMap<String, String>(attributeMap.getLength());
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            Node attr = attributeMap.item(i);
            if (!(attr instanceof Attr)) continue;
            attributes.put(((Attr)attr).getName(), ((Attr)attr).getValue());
        }
        return attributes;
    }

    public static Document readDocumentFromString(String document) throws IOException, SAXException {
        if (document == null) {
            throw new NullPointerException("configInputStream");
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return docBuilder.parse(new InputSource(new StringReader(document)));
        }
        catch (ParserConfigurationException e) {
            PatcherLog.error("Java was bad, this shouldn't happen. DocBuilder instantiation via default docBuilderFactory failed", e);
            return null;
        }
    }

    public static String makePatchXmlFromJson(String json) {
        Matcher m = stringMatcher.matcher(json);
        StringBuffer sb = new StringBuffer(json.length());
        while (m.find()) {
            m.appendReplacement(sb, DomUtil.escapeStringForJson(m.group(1)).replace("\\", "\\\\").replace("$", "\\$"));
        }
        m.appendTail(sb);
        json = sb.toString();
        try {
            String xml = DomUtil.toString(new JSONObject(json), null);
            PatcherLog.trace("Converted JSON to XML: " + xml);
            return xml;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Invalid json: " + json, e);
        }
    }

    static String toString(Object object, String tagName) throws JSONException {
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            Object value;
            String key;
            Iterator keys;
            JSONObject jo = (JSONObject)object;
            if (tagName != null) {
                sb.append('<');
                sb.append(tagName);
                keys = jo.keys();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    if ("target".equals(key) || (value = jo.opt(key)) instanceof JSONObject || value instanceof JSONArray) continue;
                    if ("".equals(value)) {
                        sb.append(' ').append(key).append("=\"true\"");
                        continue;
                    }
                    sb.append(' ').append(key).append("=\"").append(DomUtil.escapeStringForXml(value.toString())).append('\"');
                }
                sb.append('>');
            }
            keys = jo.keys();
            while (keys.hasNext()) {
                int i;
                int length;
                JSONArray ja;
                key = (String)keys.next();
                value = jo.opt(key);
                if (value == null) {
                    value = "";
                }
                if ("target".equals(key)) {
                    if (value instanceof JSONArray) {
                        ja = (JSONArray)value;
                        length = ja.length();
                        for (i = 0; i < length; ++i) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(DomUtil.escapeStringForXml(ja.get(i).toString()));
                        }
                        continue;
                    }
                    sb.append(DomUtil.escapeStringForXml(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    ja = (JSONArray)value;
                    length = ja.length();
                    for (i = 0; i < length; ++i) {
                        value = ja.get(i);
                        if (value instanceof JSONArray) {
                            sb.append('<');
                            sb.append(key);
                            sb.append('>');
                            sb.append(DomUtil.toString(value, null));
                            sb.append("</");
                            sb.append(key);
                            sb.append('>');
                            continue;
                        }
                        sb.append(DomUtil.toString(value, key));
                    }
                    continue;
                }
                if (!(value instanceof JSONObject)) continue;
                sb.append(DomUtil.toString(value, key));
            }
            if (tagName != null) {
                sb.append("</");
                sb.append(tagName);
                sb.append('>');
            }
            return sb.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray ja = (JSONArray)object;
            int length = ja.length();
            for (int i = 0; i < length; ++i) {
                sb.append(DomUtil.toString(ja.opt(i), tagName == null ? "array" : tagName));
            }
            return sb.toString();
        }
        String string = DomUtil.escapeStringForXml(object.toString());
        return tagName == null ? '\"' + string + '\"' : (string.length() == 0 ? '<' + tagName + "/>" : '<' + tagName + '>' + string + "</" + tagName + '>');
    }

    static String escapeStringForXml(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int length = string.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String escapeStringForJson(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readInputStreamToString(InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            String string = CharStreams.toString((Readable)inputStreamReader);
            return string;
        }
        catch (IOException e) {
            throw Throw.sneaky(e);
        }
    }
}

