/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.util.PlayerInventoryHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.ThreadedFileIOBase;

public class PlayerInventoryStorage {
    public static final PlayerInventoryStorage INSTANCE = new PlayerInventoryStorage();
    public static final String DEFAULT_PLAYER_INVENTORY_GROUP = "__default";
    @Nullable
    private File playerFileDirRoot;

    public void setWorldDir(@Nullable File worldDir) {
        if (worldDir != null) {
            this.playerFileDirRoot = new File(new File(worldDir, "justenoughdimensions"), "player_inventories");
        }
    }

    public void readPlayerInventoryDataForGroup(EntityPlayer player, String group) {
        if (this.playerFileDirRoot != null) {
            File file;
            NBTTagCompound nbt = null;
            File dir = new File(this.playerFileDirRoot, group);
            if (dir.exists() && dir.isDirectory() && (file = new File(dir, player.func_110124_au().toString() + ".dat")).exists() && file.isFile() && file.canRead()) {
                try {
                    FileInputStream is = new FileInputStream(file);
                    nbt = CompressedStreamTools.func_74796_a((InputStream)is);
                    is.close();
                }
                catch (Exception e) {
                    JustEnoughDimensions.logger.warn("Failed to read player inventory data from file '{}'", (Object)file.getAbsolutePath());
                }
            }
            PlayerInventoryHandler.INSTANCE.restorePlayerInventories(player, nbt);
        }
    }

    public void writePlayerInventoryDataForGroup(EntityPlayer player, String group) {
        if (this.playerFileDirRoot != null) {
            File dir = new File(this.playerFileDirRoot, group);
            if (!dir.exists() && !dir.mkdirs()) {
                JustEnoughDimensions.logger.warn("Failed to create directory for player inventory group: '{}'", (Object)dir.getAbsolutePath());
            }
            if (dir.exists() && dir.isDirectory()) {
                File fileTmp = new File(dir, player.func_110124_au().toString() + ".dat.tmp");
                File fileReal = new File(dir, player.func_110124_au().toString() + ".dat");
                NBTTagCompound nbt = new NBTTagCompound();
                PlayerInventoryHandler.INSTANCE.savePlayerInventories(player, nbt);
                ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
                    try {
                        FileOutputStream os = new FileOutputStream(fileTmp);
                        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)os);
                        os.close();
                        if (fileReal.exists()) {
                            fileReal.delete();
                        }
                        fileTmp.renameTo(fileReal);
                    }
                    catch (Exception e) {
                        JustEnoughDimensions.logger.warn("Failed to write player inventory data to file '{}'", (Object)fileTmp.getAbsolutePath(), (Object)e);
                    }
                    return false;
                });
            }
        }
    }
}

