/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.pipeline;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.render.property.IOMode;
import crazypants.enderio.base.render.util.QuadCollector;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;

public class OverlayHolder {
    @Nonnull
    private static final QuadCollector[][] data = new QuadCollector[EnumFacing.values().length][IOMode.EnumIOMode.values().length];

    public static void collectOverlayQuads(@Nonnull ModelBakeEvent event) {
        Block block = ModObject.block_machine_io.getBlockNN();
        Map locations = event.getModelManager().func_174954_c().func_178120_a().func_188181_b(block);
        for (IOMode mode : IOMode.MODES) {
            IBlockState state = block.func_176223_P().func_177226_a((IProperty)IOMode.IO, (Comparable)mode);
            ModelResourceLocation mrl = (ModelResourceLocation)locations.get(state);
            if (mrl == null) {
                throw new RuntimeException("Model for state " + state + " failed to load from " + mrl + ". ");
            }
            IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)mrl);
            if (model == null) {
                Log.warn("Model for state " + state + " failed to load from " + mrl + ".");
                continue;
            }
            QuadCollector quads = new QuadCollector();
            BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
            BlockRenderLayer layer = block.func_180664_k();
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            List generalQuads = model.func_188616_a(state, null, 0L);
            if (!generalQuads.isEmpty()) {
                quads.addQuads(null, layer, generalQuads);
            }
            for (EnumFacing face1 : EnumFacing.values()) {
                List faceQuads = model.func_188616_a(state, mode.getDirection(), 0L);
                if (faceQuads.isEmpty()) continue;
                quads.addQuads(face1, layer, faceQuads);
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
            OverlayHolder.data[mode.getDirection().ordinal()][mode.getIomode().ordinal()] = quads;
        }
    }

    @Nullable
    public static QuadCollector getOverlay(EnumMap<EnumFacing, IOMode.EnumIOMode> overlay) {
        QuadCollector quads = null;
        if (overlay != null) {
            for (Map.Entry<EnumFacing, IOMode.EnumIOMode> entry : overlay.entrySet()) {
                quads = data[entry.getKey().ordinal()][entry.getValue().ordinal()].combine(quads);
            }
        }
        return quads;
    }
}

