/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.fuel;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.machine.fuel.ISolidFuelHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolidFuelCenter {
    @Nonnull
    private static final NNList<ISolidFuelHandler> HANDLERS = new NNList();
    private static final ISolidFuelHandler DEFAULT;

    private SolidFuelCenter() {
    }

    public static void registerSolidFuelHandler(@Nonnull ISolidFuelHandler handler) {
        HANDLERS.add((Object)handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISolidFuelHandler getActiveSolidFuelHandler() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (NullHelper.untrust((Object)player) == null) {
            return DEFAULT;
        }
        if (player.field_71070_bA instanceof ISolidFuelHandler) {
            return (ISolidFuelHandler)player.field_71070_bA;
        }
        if (player.field_71070_bA instanceof ISolidFuelHandler.Provider) {
            return ((ISolidFuelHandler.Provider)player.field_71070_bA).getSolidFuelHandler();
        }
        return DEFAULT;
    }

    static {
        HANDLERS.add((Object)new ISolidFuelHandler(){

            @Override
            public boolean isInGUI() {
                return false;
            }

            @Override
            public int getPowerUsePerTick() {
                return 0;
            }

            @Override
            public long getBurnTime(@Nonnull ItemStack itemstack) {
                return -1L;
            }
        });
        DEFAULT = new ISolidFuelHandler(){

            @Override
            public boolean isInGUI() {
                for (ISolidFuelHandler handler : HANDLERS) {
                    if (!handler.isInGUI()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int getPowerUsePerTick() {
                for (ISolidFuelHandler handler : HANDLERS) {
                    int powerUsePerTick = handler.getPowerUsePerTick();
                    if (powerUsePerTick < 0) continue;
                    return powerUsePerTick;
                }
                return 0;
            }

            @Override
            public long getBurnTime(@Nonnull ItemStack itemstack) {
                for (ISolidFuelHandler handler : HANDLERS) {
                    long burnTime = handler.getBurnTime(itemstack);
                    if (burnTime < 0L) continue;
                    return burnTime;
                }
                return -1L;
            }
        };
    }
}

