/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.autosave.BaseHandlers;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

@Storable
public class SoulFilter
implements IItemFilter.WithGhostSlots {
    public static final int GUI_ROWS = 5;
    @Store
    @Nonnull
    private final NNList<CapturedMob> souls = new NNList();
    @Store
    private boolean blacklist = false;
    @Store
    private boolean sticky = false;
    @Store
    private int slotCount = 9;

    @Override
    public boolean isValid() {
        return !this.isEmpty();
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(boolean blacklist) {
        this.blacklist = blacklist;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void setSlotCount(int slotCount) {
        this.slotCount = slotCount;
    }

    public NNList<CapturedMob> getSouls() {
        return this.souls;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        Reader.read((Registry)BaseHandlers.REGISTRY, (NBTTagCompound)nbtRoot, (Object)this);
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        Writer.write((Registry)BaseHandlers.REGISTRY, (NBTTagCompound)nbtRoot, (Object)this);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)tag, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        this.readFromNBT(NetworkUtil.readNBTTagCompound((ByteBuf)buf));
    }

    @Override
    public boolean isEmpty() {
        return this.souls.isEmpty();
    }

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inv, @Nonnull ItemStack item) {
        if (CapturedMob.containsSoul(item)) {
            CapturedMob input = CapturedMob.create(item);
            for (CapturedMob mob : this.souls) {
                if (!mob.isSameType(input)) continue;
                return !this.blacklist;
            }
        }
        return this.blacklist;
    }

    @Override
    public void setInventorySlotContents(int slot, @Nonnull ItemStack stack) {
        CapturedMob input = null;
        if (CapturedMob.containsSoul(stack)) {
            input = CapturedMob.create(stack);
        }
        if (input != null) {
            if (slot < this.souls.size()) {
                this.souls.set(slot, (Object)input);
                for (CapturedMob existing : this.souls) {
                    if (existing == input || !existing.isSameType(input)) continue;
                    this.souls.remove(slot);
                    return;
                }
            } else {
                for (CapturedMob existing : this.souls) {
                    if (!existing.isSameType(input)) continue;
                    return;
                }
                this.souls.add((Object)input);
            }
        } else if (slot < this.souls.size()) {
            this.souls.remove(slot);
        }
    }

    @Override
    @Nonnull
    public ItemStack getInventorySlotContents(int slot) {
        return Prep.getEmpty();
    }

    @Override
    public void createGhostSlots(@Nonnull NNList<GhostSlot> slots, int xOffset, int yOffset, @Nullable Runnable cb) {
        int row = 0;
        int col = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            int x = xOffset + col * 81;
            int y = yOffset + row * 18;
            slots.add((Object)new SoulFilterGhostSlot(i, x, y, cb));
            if (++row < 5) continue;
            row = 0;
            ++col;
        }
    }

    public class SoulFilterGhostSlot
    extends GhostSlot {
        private final Runnable cb;

        SoulFilterGhostSlot(int slot, int x, int y, Runnable cb) {
            this.setX(x);
            this.setY(y);
            this.setSlot(slot);
            this.cb = cb;
            this.setDisplayStdOverlay(false);
            this.setStackSizeLimit(1);
        }

        public void putStack(@Nonnull ItemStack stack, int realsize) {
            SoulFilter.this.setInventorySlotContents(this.getSlot(), stack);
            this.cb.run();
        }

        @Nonnull
        public ItemStack getStack() {
            return SoulFilter.this.getInventorySlotContents(this.getSlot());
        }
    }
}

