/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.power.PowerHandlerUtil;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class PowerItemFilter
implements IItemFilter {
    public static final int MAX_LEVEL = 4;
    CmpMode mode = CmpMode.EQUAL;
    boolean sticky;
    int level = 4;

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        IEnergyStorage chargable = PowerHandlerUtil.getCapability((ICapabilityProvider)item, null);
        if (chargable != null) {
            int max = chargable.getMaxEnergyStored();
            int cur = chargable.getEnergyStored();
            int ref = (int)((long)max * (long)this.level / 4L);
            switch (this.mode) {
                case LESS: {
                    return cur < ref;
                }
                case LESS_EQUAL: {
                    return cur <= ref;
                }
                case EQUAL: {
                    return cur == ref;
                }
                case MORE_EQUAL: {
                    return cur >= ref;
                }
                case MORE: {
                    return cur > ref;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public CmpMode getMode() {
        return this.mode;
    }

    public void setMode(CmpMode mode) {
        this.mode = mode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.mode = CmpMode.values()[nbtRoot.func_74771_c("mode") & 0xFF];
        this.level = nbtRoot.func_74765_d("level");
        this.sticky = nbtRoot.func_74767_n("sticky");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74774_a("mode", (byte)this.mode.ordinal());
        nbtRoot.func_74777_a("level", (short)this.level);
        nbtRoot.func_74757_a("sticky", this.sticky);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)settingsTag, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readSettingsFromNBT(settingsTag);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public static enum CmpMode {
        LESS,
        LESS_EQUAL,
        EQUAL,
        MORE_EQUAL,
        MORE;


        public CmpMode next() {
            CmpMode[] values = CmpMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

