/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world.data.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.utility.AnnotatedInstanceUtil;
import org.dave.compactmachines3.world.data.provider.AbstractExtraTileDataProvider;

public class ExtraTileDataProviderRegistry {
    private static final List<AbstractExtraTileDataProvider> extraTileData = new ArrayList<AbstractExtraTileDataProvider>();

    public static void registerExtraTileDataProviders() {
        for (AbstractExtraTileDataProvider etdp : AnnotatedInstanceUtil.getExtraTileDataProviders()) {
            if (etdp.getName() == null) continue;
            CompactMachines3.logger.info("Registered extra tile data provider '{}'", (Object)etdp.getName());
            extraTileData.add(etdp);
        }
    }

    public static boolean hasDataProvider(TileEntity tileEntity) {
        return extraTileData.stream().anyMatch(provider -> provider.worksWith(tileEntity));
    }

    public static List<AbstractExtraTileDataProvider> getDataProviders(TileEntity tileEntity) {
        return extraTileData.stream().filter(provider -> provider.worksWith(tileEntity)).collect(Collectors.toList());
    }
}

