/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.schema;

import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.utility.ResourceLoader;
import org.dave.compactmachines3.utility.SerializationHelper;

public class SchemaRegistry {
    public static SchemaRegistry instance;
    private HashMap<String, Schema> schemas;

    public SchemaRegistry() {
        this.loadSchemas();
    }

    public static void init() {
        instance = new SchemaRegistry();
    }

    public Set<String> getSchemaNames() {
        return this.schemas.keySet();
    }

    public Collection<Schema> getSchemas() {
        return this.schemas.values();
    }

    private void loadSchemas() {
        this.schemas = new HashMap();
        ResourceLoader loader = new ResourceLoader(CompactMachines3.class, ConfigurationHandler.schemaDirectory, "assets/compactmachines3/config/schemas/");
        for (Map.Entry<String, InputStream> entry : loader.getResources().entrySet()) {
            String filename = entry.getKey();
            InputStream is = entry.getValue();
            if (!filename.endsWith(".json")) continue;
            Schema schema = (Schema)SerializationHelper.GSON.fromJson(new JsonReader((Reader)new InputStreamReader(is)), Schema.class);
            if (schema == null) {
                CompactMachines3.logger.error("Could not deserialize schema from file: \"{}\"", (Object)filename);
                continue;
            }
            CompactMachines3.logger.info("Loaded schema: {} [size={}, blocks={}]", (Object)schema.getName(), (Object)schema.getSize(), (Object)schema.getBlocks().size());
            this.addSchema(schema);
        }
    }

    public void addSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema);
    }

    public boolean hasSchema(String name) {
        return this.schemas.containsKey(name);
    }

    public Schema getSchema(String name) {
        return this.schemas.get(name);
    }
}

