/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib;

import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.TRLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CompatForgeRegistryEntry {
    public static final Class<?> CLASS = TRLUtils.MC_VERSION_NUMBER > 11 ? IForgeRegistryEntry.class : TRLUtils.getClass("net.minecraftforge.fml.common.registry.IForgeRegistryEntry");
    private static final Method GET_REGISTRY_NAME = TRLUtils.MC_VERSION_NUMBER > 11 || CLASS == null ? null : TRLUtils.findMethod(CLASS, "getRegistryName", new Class[0]);
    private final Object entry;

    public CompatForgeRegistryEntry(Object entry) {
        CompatForgeRegistryEntry.checkSupported();
        if (!CLASS.isAssignableFrom(entry.getClass())) {
            throw new IllegalArgumentException("Not an IForgeRegistryEntry: " + entry);
        }
        this.entry = entry;
    }

    public Object getEntry() {
        return this.entry;
    }

    public ResourceLocation getRegistryName() {
        CompatForgeRegistryEntry.checkSupported();
        if (TRLUtils.MC_VERSION_NUMBER > 11) {
            return ((IForgeRegistryEntry)this.entry).getRegistryName();
        }
        try {
            return (ResourceLocation)GET_REGISTRY_NAME.invoke(this.entry, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            TRLUtils.crashReport("Failed to get resource location of registry entry", ex);
            return null;
        }
    }

    private static void checkSupported() {
        if (CLASS == null) {
            throw new UnsupportedOperationException("Not supported on Minecraft 1.8");
        }
    }
}

