/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.frame.endportal;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.detector.SidedFrameDetector;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class LateralEndPortalDetector
extends SidedFrameDetector {
    private final Block block;
    private final Function<FrameType, FrameSize> defaultSize;

    public LateralEndPortalDetector(Block block, Function<FrameType, FrameSize> defaultSize) {
        super(FrameType.LATERAL);
        this.block = block;
        this.defaultSize = defaultSize;
    }

    @Override
    public Function<FrameType, FrameSize> getDefaultSize() {
        return this.defaultSize;
    }

    @Override
    protected boolean test(Frame frame) {
        return true;
    }

    @Override
    protected boolean testTop(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(state, EnumFacing.SOUTH);
    }

    @Override
    protected boolean testRight(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(state, EnumFacing.WEST);
    }

    @Override
    protected boolean testBottom(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(state, EnumFacing.NORTH);
    }

    @Override
    protected boolean testLeft(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(state, EnumFacing.EAST);
    }

    public Block getBlock() {
        return this.block;
    }

    private boolean test(IBlockState state, EnumFacing facing) {
        return state.func_177230_c() == this.block && (Boolean)state.func_177229_b((IProperty)BlockEndPortalFrame.field_176507_b) != false && state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == facing;
    }
}

