/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.caliper.profiling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.util.AnnotationUtils;
import net.darkhax.caliper.Caliper;
import net.darkhax.caliper.profiling.Profiler;
import net.darkhax.caliper.profiling.RegisterProfiler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ProfilerManager {
    private final List<Profiler> features = new ArrayList<Profiler>();

    public void init(ASMDataTable asmDataTable) {
        for (Map.Entry profiler : AnnotationUtils.getAnnotations((ASMDataTable)asmDataTable, RegisterProfiler.class, Profiler.class).entrySet()) {
            RegisterProfiler annotation = (RegisterProfiler)profiler.getValue();
            if (annotation == null) {
                Caliper.LOG.warn("Annotation for {} was null!", new Object[]{((Profiler)profiler.getKey()).getClass().getCanonicalName()});
                continue;
            }
            this.registerFeature((Profiler)profiler.getKey(), annotation.name(), annotation.description());
        }
    }

    private void registerFeature(Profiler profiler, String name, String description) {
        if (profiler.isEnabled()) {
            this.features.add(profiler);
            if (profiler.hasEvents()) {
                MinecraftForge.EVENT_BUS.register((Object)profiler);
            }
        }
    }

    public boolean isLoaded() {
        return !this.getFeatures().isEmpty();
    }

    public List<Profiler> getFeatures() {
        return this.features;
    }
}

