/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ItemEmergencyKit;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityEmergencyBox
extends TileEntity
implements ITickable,
IPacketReceiver {
    private static final float SPEED = 4.0f;
    private final HashSet<BlockVec3> airToRestore = new HashSet();
    public float angleA = 0.0f;
    public float angleB = 0.0f;
    public float angleC = 0.0f;
    public float angleD = 0.0f;
    public float lastAngleA = 0.0f;
    public float lastAngleB = 0.0f;
    public float lastAngleC = 0.0f;
    public float lastAngleD = 0.0f;
    private boolean openN = false;
    private boolean openW = false;
    private boolean openS = false;
    private boolean openE = false;
    private int cooldown = 0;
    private boolean activated = false;
    private Vec3d vec3Centre;
    private Vec3d thisVec3;
    private AxisAlignedBB mobsAABB;

    public void func_73660_a() {
        if (!this.activated) {
            this.activated = true;
            this.setLightBlocks();
            this.thisVec3 = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
            this.vec3Centre = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.mobsAABB = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 14), (double)(this.field_174879_c.func_177956_o() - 7), (double)(this.field_174879_c.func_177952_p() - 14), (double)(this.field_174879_c.func_177958_n() + 14), (double)(this.field_174879_c.func_177956_o() + 7), (double)(this.field_174879_c.func_177952_p() + 14));
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.openN && this.angleA < 90.0f) {
                this.lastAngleA = this.angleA;
                this.angleA += 4.0f;
                if (this.angleA > 90.0f) {
                    this.angleA = 90.0f;
                }
            }
            if (this.openW && this.angleB < 90.0f) {
                this.lastAngleB = this.angleB;
                this.angleB += 4.0f;
                if (this.angleB > 90.0f) {
                    this.angleB = 90.0f;
                }
            }
            if (this.openS && this.angleC < 90.0f) {
                this.lastAngleC = this.angleC;
                this.angleC += 4.0f;
                if (this.angleC > 90.0f) {
                    this.angleC = 90.0f;
                }
            }
            if (this.openE && this.angleD < 90.0f) {
                this.lastAngleD = this.angleD;
                this.angleD += 4.0f;
                if (this.angleD > 90.0f) {
                    this.angleD = 90.0f;
                }
            }
            if (!this.openN && this.angleA > 0.0f) {
                this.lastAngleA = this.angleA;
                this.angleA -= 4.0f;
                if (this.angleA < 0.0f) {
                    this.angleA = 0.0f;
                }
            }
            if (!this.openW && this.angleB > 0.0f) {
                this.lastAngleB = this.angleB;
                this.angleB -= 4.0f;
                if (this.angleB < 0.0f) {
                    this.angleB = 0.0f;
                }
            }
            if (!this.openS && this.angleC > 0.0f) {
                this.lastAngleC = this.angleC;
                this.angleC -= 4.0f;
                if (this.angleC < 0.0f) {
                    this.angleC = 0.0f;
                }
            }
            if (!this.openE && this.angleD > 0.0f) {
                this.lastAngleD = this.angleD;
                this.angleD -= 4.0f;
                if (this.angleD < 0.0f) {
                    this.angleD = 0.0f;
                }
            }
        } else {
            AxisAlignedBB neighbour;
            AxisAlignedBB check;
            IBlockState bs;
            BlockPos testPos;
            boolean clash;
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            boolean updateRequired = false;
            if (this.openN) {
                clash = false;
                testPos = this.field_174879_c.func_177964_d(1);
                bs = this.field_145850_b.func_180495_p(testPos);
                if (!(bs.func_177230_c() instanceof BlockAir)) {
                    if (bs.func_185913_b()) {
                        clash = true;
                    } else {
                        check = new AxisAlignedBB(0.125, 0.125, 0.6875, 0.875, 0.875, 1.0);
                        neighbour = bs.func_185890_d((IBlockAccess)this.field_145850_b, testPos);
                        if (neighbour != null) {
                            clash = check.func_72326_a(neighbour);
                        }
                    }
                }
                if (clash) {
                    this.openN = false;
                    updateRequired = true;
                }
            }
            if (this.openS) {
                clash = false;
                testPos = this.field_174879_c.func_177970_e(1);
                bs = this.field_145850_b.func_180495_p(testPos);
                if (!(bs.func_177230_c() instanceof BlockAir)) {
                    if (bs.func_185913_b()) {
                        clash = true;
                    } else {
                        check = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.3125);
                        neighbour = bs.func_185890_d((IBlockAccess)this.field_145850_b, testPos);
                        if (neighbour != null) {
                            clash = check.func_72326_a(neighbour);
                        }
                    }
                }
                if (clash) {
                    this.openS = false;
                    updateRequired = true;
                }
            }
            if (this.openW) {
                clash = false;
                testPos = this.field_174879_c.func_177985_f(1);
                bs = this.field_145850_b.func_180495_p(testPos);
                if (!(bs.func_177230_c() instanceof BlockAir)) {
                    if (bs.func_185913_b()) {
                        clash = true;
                    } else {
                        check = new AxisAlignedBB(0.6875, 0.125, 0.125, 1.0, 0.875, 0.875);
                        neighbour = bs.func_185890_d((IBlockAccess)this.field_145850_b, testPos);
                        if (neighbour != null) {
                            clash = check.func_72326_a(neighbour);
                        }
                    }
                }
                if (clash) {
                    this.openW = false;
                    updateRequired = true;
                }
            }
            if (this.openE) {
                clash = false;
                testPos = this.field_174879_c.func_177965_g(1);
                bs = this.field_145850_b.func_180495_p(testPos);
                if (!(bs.func_177230_c() instanceof BlockAir)) {
                    if (bs.func_185913_b()) {
                        clash = true;
                    } else {
                        check = new AxisAlignedBB(0.0, 0.125, 0.125, 0.3125, 0.875, 0.875);
                        neighbour = bs.func_185890_d((IBlockAccess)this.field_145850_b, testPos);
                        if (neighbour != null) {
                            clash = check.func_72326_a(neighbour);
                        }
                    }
                }
                if (clash) {
                    this.openE = false;
                    updateRequired = true;
                }
            }
            if (updateRequired) {
                this.updateClients();
            }
            if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                this.scareMobs();
            }
        }
    }

    private void scareMobs() {
        List moblist = this.field_145850_b.func_175674_a(null, this.mobsAABB, IMob.field_82192_a);
        if (!moblist.isEmpty()) {
            for (Entity entry : moblist) {
                double distanceCurrent;
                double distanceNew;
                Vec3d vecNewTarget;
                EntityCreature mob;
                PathNavigate nav;
                if (!(entry instanceof EntityCreature) || !(entry instanceof IEntityBreathable) || (nav = (mob = (EntityCreature)entry).func_70661_as()) == null || (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)mob, (int)12, (int)5, (Vec3d)this.vec3Centre)) == null && (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)mob, (int)14, (int)7, (Vec3d)this.vec3Centre)) == null || !((distanceNew = vecNewTarget.func_72436_e(this.thisVec3)) > (distanceCurrent = this.thisVec3.func_72436_e(new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v))))) continue;
                Vec3d vecOldTarget = null;
                if (nav.func_75505_d() != null && !nav.func_75505_d().func_75879_b()) {
                    vecOldTarget = nav.func_75505_d().func_75878_a((Entity)mob);
                }
                if (vecOldTarget != null && !(distanceCurrent > vecOldTarget.func_72436_e(this.thisVec3))) continue;
                nav.func_75492_a(vecNewTarget.field_72450_a, vecNewTarget.field_72448_b, vecNewTarget.field_72449_c, 1.1);
            }
        }
    }

    public float getAngleA(float f) {
        float result = this.angleA + (this.angleA - this.lastAngleA) * f;
        if (result > 90.0f) {
            result = 90.0f;
        }
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    public float getAngleB(float f) {
        float result = this.angleB + (this.angleB - this.lastAngleB) * f;
        if (result > 90.0f) {
            result = 90.0f;
        }
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    public float getAngleC(float f) {
        float result = this.angleC + (this.angleC - this.lastAngleC) * f;
        if (result > 90.0f) {
            result = 90.0f;
        }
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    public float getAngleD(float f) {
        float result = this.angleD + (this.angleD - this.lastAngleD) * f;
        if (result > 90.0f) {
            result = 90.0f;
        }
        if (result < 0.0f) {
            result = 0.0f;
        }
        return result;
    }

    public void click(EntityPlayer player, EnumFacing side, boolean kitted) {
        switch (side) {
            case NORTH: {
                if (this.openN && this.cooldown == 0) {
                    if (kitted) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(GCItems.emergencyKit), (int)0);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176223_P(), 3);
                        break;
                    }
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemEmergencyKit) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176203_a(1), 3);
                        this.openW = false;
                        this.openS = false;
                        this.openE = false;
                    }
                }
                this.cooldown = 12;
                this.openN = !this.openN;
                this.updateClients();
                break;
            }
            case WEST: {
                if (this.openW && this.cooldown == 0) {
                    if (kitted) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(GCItems.emergencyKit), (int)0);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176223_P(), 3);
                        break;
                    }
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemEmergencyKit) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176203_a(1), 3);
                        this.openN = false;
                        this.openS = false;
                        this.openE = false;
                    }
                }
                this.cooldown = 12;
                this.openW = !this.openW;
                this.updateClients();
                break;
            }
            case SOUTH: {
                if (this.openS && this.cooldown == 0) {
                    if (kitted) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(GCItems.emergencyKit), (int)0);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176223_P(), 3);
                        break;
                    }
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemEmergencyKit) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176203_a(1), 3);
                        this.openN = false;
                        this.openW = false;
                        this.openE = false;
                    }
                }
                this.cooldown = 12;
                this.openS = !this.openS;
                this.updateClients();
                break;
            }
            case EAST: {
                if (this.openE && this.cooldown == 0) {
                    if (kitted) {
                        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(GCItems.emergencyKit), (int)0);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176223_P(), 3);
                        break;
                    }
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemEmergencyKit) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        this.field_145850_b.func_180501_a(this.field_174879_c, GCBlocks.emergencyBox.func_176203_a(1), 3);
                        this.openN = false;
                        this.openW = false;
                        this.openS = false;
                    }
                }
                this.cooldown = 12;
                this.openE = !this.openE;
                this.updateClients();
                break;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int data = nbt.func_74762_e("open");
        this.openN = (data & 1) == 1;
        this.openW = (data & 2) == 2;
        this.openS = (data & 4) == 4;
        boolean bl = this.openE = (data & 8) == 8;
        if (GCCoreUtil.getEffectiveSide() == Side.SERVER) {
            this.airToRestore.clear();
            NBTTagList airBlocks = nbt.func_150295_c("air", 10);
            if (airBlocks.func_74745_c() > 0) {
                for (int j = airBlocks.func_74745_c() - 1; j >= 0; --j) {
                    NBTTagCompound tag1 = airBlocks.func_150305_b(j);
                    if (tag1 == null) continue;
                    this.airToRestore.add(BlockVec3.readFromNBT(tag1));
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        int data = (this.openN ? 1 : 0) + (this.openW ? 2 : 0) + (this.openS ? 4 : 0) + (this.openE ? 8 : 0);
        nbt.func_74768_a("open", data);
        NBTTagList airBlocks = new NBTTagList();
        for (BlockVec3 vec : this.airToRestore) {
            NBTTagCompound tag = new NBTTagCompound();
            vec.writeToNBT(tag);
            airBlocks.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("air", (NBTBase)airBlocks);
        return nbt;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int data = (this.openN ? 1 : 0) + (this.openW ? 2 : 0) + (this.openS ? 4 : 0) + (this.openE ? 8 : 0);
        sendData.add((byte)data);
        for (BlockVec3 vec : this.airToRestore) {
            sendData.add(vec);
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.field_145850_b.field_72995_K) {
            try {
                byte data = buffer.readByte();
                this.openN = (data & 1) == 1;
                this.openW = (data & 2) == 2;
                this.openS = (data & 4) == 4;
                boolean bl = this.openE = (data & 8) == 8;
                while (buffer.readableBytes() >= 12) {
                    int x = buffer.readInt();
                    int y = buffer.readInt();
                    int z = buffer.readInt();
                    this.airToRestore.add(new BlockVec3(x, y, z));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        }
    }

    private void updateClients() {
        GalacticraftCore.packetPipeline.sendToAllAround(new PacketDynamic(this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_145850_b), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void brightenAir(BlockPos blockpos, IBlockState newState) {
        Chunk chunk = this.field_145850_b.func_175726_f(blockpos);
        IBlockState oldState = chunk.func_177436_a(blockpos, newState);
        if (this.field_145850_b.field_72995_K && oldState != null) {
            this.field_145850_b.markAndNotifyBlock(blockpos, chunk, oldState, newState, 2);
        }
        this.airToRestore.add(new BlockVec3(blockpos));
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, blockpos);
        this.func_70296_d();
    }

    private void setDarkerAir(BlockVec3 vec) {
        IBlockState newState;
        BlockPos blockpos = vec.toBlockPos();
        Block b = this.field_145850_b.func_180495_p(blockpos).func_177230_c();
        if (b == GCBlocks.brightAir) {
            newState = Blocks.field_150350_a.func_176223_P();
        } else if (b == GCBlocks.brightBreatheableAir) {
            newState = GCBlocks.breatheableAir.func_176223_P();
        } else {
            return;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(blockpos);
        IBlockState oldState = chunk.func_177436_a(blockpos, newState);
        if (this.field_145850_b.field_72995_K && oldState != null) {
            this.field_145850_b.markAndNotifyBlock(blockpos, chunk, oldState, newState, 2);
        }
        this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, blockpos);
    }

    private void revertAir() {
        if (this.airToRestore.isEmpty()) {
            return;
        }
        boolean index = false;
        for (BlockVec3 vec : this.airToRestore) {
            this.setDarkerAir(vec);
        }
        this.airToRestore.clear();
        this.func_70296_d();
    }

    public void func_145843_s() {
        this.revertAir();
        super.func_145843_s();
    }

    private void setLightBlocks() {
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() - 6, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() + 6, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 6));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 6));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() - 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 5));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() - 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 5));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() + 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 5));
        this.setLightBlock(new BlockPos(this.field_174879_c.func_177958_n() + 5, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 5));
    }

    private boolean setLightBlock(BlockPos blockPos) {
        IBlockState bs = this.field_145850_b.func_180495_p(blockPos);
        if (bs.func_177230_c() == Blocks.field_150350_a) {
            this.brightenAir(blockPos, GCBlocks.brightAir.func_176223_P());
            return true;
        }
        if (bs.func_177230_c() == GCBlocks.breatheableAir) {
            this.brightenAir(blockPos, GCBlocks.brightBreatheableAir.func_176223_P());
            return true;
        }
        bs = this.field_145850_b.func_180495_p(blockPos = blockPos.func_177981_b(1));
        if (bs.func_177230_c() == Blocks.field_150350_a) {
            this.brightenAir(blockPos, GCBlocks.brightAir.func_176223_P());
            return true;
        }
        if (bs.func_177230_c() == GCBlocks.breatheableAir) {
            this.brightenAir(blockPos, GCBlocks.brightBreatheableAir.func_176223_P());
            return true;
        }
        return false;
    }
}

