/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.api.recipe.IRecipeUpdatable;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class OreRecipeUpdatable
extends ShapedOreRecipe
implements IRecipeUpdatable {
    public OreRecipeUpdatable(ResourceLocation group, Block result, Object ... recipe) {
        super(group, new ItemStack(result), recipe);
    }

    public OreRecipeUpdatable(ResourceLocation group, Item result, Object ... recipe) {
        super(group, new ItemStack(result), recipe);
    }

    public OreRecipeUpdatable(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, CraftingHelper.parseShaped((Object[])recipe));
    }

    public OreRecipeUpdatable(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    public static boolean itemListContains(List<?> test, ItemStack stack) {
        for (Object b : test) {
            if (!(b instanceof ItemStack) || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)b)) || !RecipeUtil.areItemStackTagsEqual(stack, (ItemStack)b)) continue;
            return true;
        }
        return false;
    }

    public static OreRecipeUpdatable factory(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new OreRecipeUpdatable(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
    }

    @Override
    public void replaceInput(ItemStack inputA, List<ItemStack> inputB) {
        if (inputB.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.input.size(); ++i) {
            Ingredient test = (Ingredient)this.input.get(i);
            if (!test.apply(inputA)) continue;
            this.input.set(i, (Object)Ingredient.func_193369_a((ItemStack[])inputB.toArray(new ItemStack[inputB.size()])));
        }
    }

    @Override
    public void replaceInput(ItemStack inputB) {
        for (int i = 0; i < this.input.size(); ++i) {
            Ingredient test = (Ingredient)this.input.get(i);
            if (!(test instanceof OreIngredient) || !test.apply(inputB)) continue;
            this.input.set(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inputB}));
        }
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return OreRecipeUpdatable.factory(context, json);
        }
    }
}

