/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.entities.EntityAIArrowAttack;
import micdoodle8.mods.galacticraft.core.entities.EntityBossBase;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class EntitySkeletonBoss
extends EntityBossBase
implements IEntityBreathable,
IRangedAttackMob,
IIgnoreShift {
    private static final ItemStack defaultHeldItem = new ItemStack((Item)Items.field_151031_f, 1);
    public int throwTimer;
    public int postThrowDelay = 20;
    public Entity thrownEntity;
    public Entity targetEntity;
    protected long ticks = 0L;

    public EntitySkeletonBoss(World par1World) {
        super(par1World);
        this.func_70105_a(1.5f, 4.0f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack(this, 1.0, 25, 10.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        double difficulty = 0.0;
        switch (this.field_70170_p.func_175659_aa()) {
            case HARD: {
                difficulty = 2.0;
                break;
            }
            case NORMAL: {
                difficulty = 1.0;
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25 + 0.075 * difficulty);
    }

    @Override
    protected void func_70609_aI() {
        super.func_70609_aI();
        if (!this.field_70170_p.field_72995_K && this.deathTicks == 100) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID(this.field_70170_p), new Object[]{Float.valueOf(1.5f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
        }
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            double offsetX = Math.sin((double)(-this.field_70759_as) / 57.29577951308232);
            double offsetZ = Math.cos((double)this.field_70759_as / 57.29577951308232);
            double offsetY = 2.0 * Math.cos((float)(this.throwTimer + this.postThrowDelay) * 0.05f);
            passenger.func_70107_b(this.field_70165_t + offsetX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + offsetY, this.field_70161_v + offsetZ);
        }
    }

    public void func_70653_a(Entity par1Entity, float par2, double par3, double par5) {
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.func_175446_cd() && this.func_184188_bt().isEmpty() && this.postThrowDelay == 0 && this.throwTimer == 0 && par1EntityPlayer.equals((Object)this.targetEntity) && this.deathTicks == 0) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_LAUGH, GCCoreUtil.getDimensionID(this.field_70170_p), new Object[0]), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
                par1EntityPlayer.func_184220_m((Entity)this);
            }
            this.throwTimer = 40;
        }
        super.func_70100_b_(par1EntityPlayer);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(GCSounds.bossOoh, this.func_70599_aP(), this.func_70647_i() + 1.0f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void func_70636_d() {
        EntityPlayer player;
        ++this.ticks;
        if (!this.field_70170_p.field_72995_K && (double)this.func_110143_aJ() <= 150.0 * ConfigManagerCore.dungeonBossHealthMod / 2.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        }
        if ((player = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 20.0, false)) != null && !player.equals((Object)this.targetEntity)) {
            if (this.func_70068_e((Entity)player) < 400.0) {
                this.func_70661_as().func_75494_a((Entity)player);
                this.targetEntity = player;
            }
        } else {
            this.targetEntity = null;
        }
        if (this.throwTimer > 0) {
            --this.throwTimer;
        }
        if (this.postThrowDelay > 0) {
            --this.postThrowDelay;
        }
        if (!this.func_184188_bt().isEmpty() && this.throwTimer == 0) {
            this.postThrowDelay = 20;
            this.thrownEntity = (Entity)this.func_184188_bt().get(0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_184226_ay();
            }
        }
        if (this.thrownEntity != null && this.postThrowDelay == 18) {
            double d0 = this.field_70165_t - this.thrownEntity.field_70165_t;
            double d1 = this.field_70161_v - this.thrownEntity.field_70161_v;
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOW, GCCoreUtil.getDimensionID(this.field_70170_p), new Object[0]), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            ((EntityPlayer)this.thrownEntity).field_70739_aP = (float)Math.atan2(d1, d0) * 57.295776f - this.field_70177_z;
            this.thrownEntity.field_70160_al = true;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            float f1 = 2.4f;
            this.thrownEntity.field_70159_w /= 2.0;
            this.thrownEntity.field_70181_x /= 2.0;
            this.thrownEntity.field_70179_y /= 2.0;
            this.thrownEntity.field_70159_w -= d0 / (double)f * (double)2.4f;
            this.thrownEntity.field_70181_x += 0.48000001907348633;
            this.thrownEntity.field_70179_y -= d1 / (double)f * (double)2.4f;
            if (this.thrownEntity.field_70181_x > (double)0.4f) {
                this.thrownEntity.field_70181_x = 0.4f;
            }
        }
        super.func_70636_d();
    }

    protected Item func_146068_u() {
        return Items.field_151032_g;
    }

    public EntityItem func_70099_a(ItemStack par1ItemStack, float par2) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)par2, this.field_70161_v, par1ItemStack);
        entityitem.field_70181_x = -2.0;
        entityitem.func_174869_p();
        if (this.captureDrops) {
            this.capturedDrops.add(entityitem);
        } else {
            this.field_70170_p.func_72838_d((Entity)entityitem);
        }
        return entityitem;
    }

    protected void func_70628_a(boolean b, int i) {
        if (this.field_70146_Z.nextInt(200) - i >= 5) {
            return;
        }
        if (i > 0) {
            ItemStack var2 = new ItemStack((Item)Items.field_151031_f);
            EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)var2, (int)5, (boolean)false);
            this.func_70099_a(var2, 0.0f);
        } else {
            this.func_145779_a((Item)Items.field_151031_f, 1);
        }
    }

    @Override
    public boolean canBreath() {
        return true;
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        if (!this.func_184188_bt().isEmpty()) {
            return;
        }
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        arrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    @Override
    public boolean shouldIgnoreShiftExit() {
        return true;
    }

    @Override
    public ItemStack getGuaranteedLoot(Random rand) {
        List<ItemStack> stackList = GalacticraftRegistry.getDungeonLoot(1);
        return stackList.get(rand.nextInt(stackList.size())).func_77946_l();
    }

    @Override
    public int getChestTier() {
        return 1;
    }

    @Override
    public void dropKey() {
        this.func_70099_a(new ItemStack(GCItems.key, 1, 0), 0.5f);
    }

    @Override
    public BossInfo.Color getHealthBarColor() {
        return BossInfo.Color.GREEN;
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

