/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.common.config;

import c4.colytra.util.ColytraUtil;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="colytra")
public class ConfigHandler {
    @Config.Name(value="Allow Colytra Separation")
    @Config.Comment(value={"True to allow separating elytras from chestplates in the crafting table, otherwise false"})
    public static boolean separateColytra = false;
    @Config.Name(value="Permission Mode")
    @Config.Comment(value={"Sets whether the Item List uses a blacklist or a whitelist"})
    public static PermissionMode permissionMode = PermissionMode.BLACKLIST;
    @Config.Name(value="Item List")
    @Config.Comment(value={"List of items by registry name to be blacklisted/whitelisted based on Permission Mode"})
    public static String[] itemList = new String[0];
    @Config.Name(value="Durability Mode")
    @Config.Comment(value={"Sets how the elytra chestplates will handle elytra durability", "Normal: Elytras will use their own separate durability", "Chestplate: Elytras will use the chestplate's durability or energy", "Infinite: Elytras will never use durability"})
    public static DurabilityMode durabilityMode = DurabilityMode.NORMAL;
    public static Baubles baubles = new Baubles();

    @Mod.EventBusSubscriber(modid="colytra")
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (evt.getModID().equals("colytra")) {
                ConfigManager.sync((String)"colytra", (Config.Type)Config.Type.INSTANCE);
                ColytraUtil.initConfigItemList();
            }
        }
    }

    public static enum DurabilityMode {
        NORMAL,
        CHESTPLATE,
        INFINITE;

    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }

    public static class Baubles {
        @Config.Name(value="Disable Baubles")
        @Config.Comment(value={"Set to true to disable the bauble Elytra"})
        @Config.RequiresMcRestart
        public boolean disableBauble = false;
    }
}

