/*
 * Decompiled with CFR 0.152.
 */
package c4.colytra.common.capabilities;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityColytraFlying {
    @CapabilityInject(value=IColytraFlying.class)
    public static final Capability<IColytraFlying> COLYTRA_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("colytra", "colytraFlying");
    private static final String FLYING_TAG = "colytra_flying";

    public static void register() {
        CapabilityManager.INSTANCE.register(IColytraFlying.class, (Capability.IStorage)new Capability.IStorage<IColytraFlying>(){

            public NBTBase writeNBT(Capability<IColytraFlying> capability, IColytraFlying instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74757_a(CapabilityColytraFlying.FLYING_TAG, instance.getColytraFlying());
                return compound;
            }

            public void readNBT(Capability<IColytraFlying> capability, IColytraFlying instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                boolean flag = compound.func_74767_n(CapabilityColytraFlying.FLYING_TAG);
                if (flag) {
                    instance.setColytraFlying();
                } else {
                    instance.clearColytraFlying();
                }
            }
        }, ColytraFlying::new);
    }

    @Nullable
    public static IColytraFlying getColytraCap(EntityLivingBase entityIn) {
        if (entityIn != null && entityIn.hasCapability(COLYTRA_CAP, DEFAULT_FACING)) {
            return (IColytraFlying)entityIn.getCapability(COLYTRA_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static ICapabilityProvider createProvider(IColytraFlying colytra) {
        return new Provider(colytra, COLYTRA_CAP, DEFAULT_FACING);
    }

    @Mod.EventBusSubscriber
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayer) {
                evt.addCapability(ID, CapabilityColytraFlying.createProvider(new ColytraFlying()));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<IColytraFlying> capability;
        final EnumFacing facing;
        final IColytraFlying instance;

        Provider(IColytraFlying instance, Capability<IColytraFlying> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<IColytraFlying> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final IColytraFlying getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing());
        }

        public void deserializeNBT(NBTBase nbt) {
            this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
        }
    }

    public static class ColytraFlying
    implements IColytraFlying {
        boolean colytraFlying = false;

        @Override
        public boolean getColytraFlying() {
            return this.colytraFlying;
        }

        @Override
        public void setColytraFlying() {
            this.colytraFlying = true;
        }

        @Override
        public void clearColytraFlying() {
            this.colytraFlying = false;
        }
    }

    public static interface IColytraFlying {
        public boolean getColytraFlying();

        public void setColytraFlying();

        public void clearColytraFlying();
    }
}

