/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.manager;

import codechicken.chunkloader.ChickenChunks;
import codechicken.chunkloader.api.IChickenChunkLoader;
import codechicken.chunkloader.manager.OrganiserStorage;
import codechicken.chunkloader.manager.PlayerLoginTracker;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.util.CommonUtils;
import codechicken.lib.util.ServerUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ChunkLoaderManager {
    private static boolean reloadDimensions = false;
    private static boolean opInteract = false;
    private static int maxChunks;
    private static int awayTimeout;
    private static HashMap<Object, ModContainer> mods;
    private static boolean loaded;

    public static void registerMod(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        if (container == null) {
            throw new NullPointerException("Mod container not found for: " + mod);
        }
        mods.put(mod, container);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)mod, (ForgeChunkManager.LoadingCallback)new DummyLoadingCallback());
    }

    public static ImmutableMap<Object, ModContainer> getHandledMods() {
        return ImmutableMap.copyOf(mods);
    }

    public static void loadWorld(WorldServer world) {
        ReviveChange.DimensionRevive.list.add(world);
    }

    public static World getWorld(int dim, boolean create) {
        if (create) {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        }
        return DimensionManager.getWorld((int)dim);
    }

    public static void load(WorldServer world) {
        if (loaded) {
            return;
        }
        loaded = true;
        ReviveChange.load();
        OrganiserStorage.IOrganiserStorage storage = OrganiserStorage.getStorage((World)world);
        PlayerLoginTracker.ILoginTracker tracker = PlayerLoginTracker.getTracker((World)world);
        try {
            File saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "chickenchunks");
            if (saveDir.exists()) {
                storage.loadLegacyData(saveDir);
                tracker.loadLegacyData(saveDir);
                File[] list = saveDir.listFiles();
                if (list == null || list.length == 0) {
                    saveDir.delete();
                    ChickenChunks.logger.info("Old ChickenChunks conversion completed! Removing old folder..");
                } else {
                    ChickenChunks.logger.warn("After conversion {} files still exist in {}, Wot..", (Object)list.length, (Object)saveDir.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            ChickenChunks.logger.warn("Exception thrown whilst converting old ChickenChunks data!", (Throwable)e);
        }
        storage.load((World)world);
    }

    public static boolean loggedInRecently(World world, String playerName) {
        if (awayTimeout == 0) {
            return true;
        }
        Long lastLogin = PlayerLoginTracker.getTracker(world).getLoginTime(playerName);
        return lastLogin != null && (System.currentTimeMillis() - lastLogin) / 60000L < (long)awayTimeout;
    }

    public static int getPlayerChunkLimit(String username) {
        int ret;
        ConfigTag config = ChickenChunks.config.getTag("players");
        if (config.containsTag(username) && (ret = config.getTag(username).getIntValue(0)) != 0) {
            return ret;
        }
        if (ServerUtils.isPlayerOP((String)username) && (ret = config.getTag("OP").getIntValue(0)) != 0) {
            return ret;
        }
        return config.getTag("DEFAULT").getIntValue(5000);
    }

    public static boolean allowOffline(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowoffline");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static boolean allowChunkViewer(String username) {
        ConfigTag config = ChickenChunks.config.getTag("allowchunkviewer");
        if (config.containsTag(username)) {
            return config.getTag(username).getBooleanValue(true);
        }
        if (ServerUtils.isPlayerOP((String)username)) {
            return config.getTag("OP").getBooleanValue(true);
        }
        return config.getTag("DEFAULT").getBooleanValue(true);
    }

    public static void initConfig(ConfigFile config) {
        config.getTag("players").setPosition(0).useBraces().setComment("Per player chunk limiting. Values ignored if 0.:Simply add <username>=<value>");
        config.getTag("players.DEFAULT").setComment("Forge gives everyone 12500 by default").getIntValue(5000);
        config.getTag("players.OP").setComment("For server op's only.").getIntValue(5000);
        config.getTag("allowoffline").setPosition(1).useBraces().setComment("If set to false, players will have to be logged in for their chunkloaders to work.:Simply add <username>=<true|false>");
        config.getTag("allowoffline.DEFAULT").getBooleanValue(true);
        config.getTag("allowoffline.OP").getBooleanValue(true);
        config.getTag("allowchunkviewer").setPosition(2).useBraces().setComment("Set to false to deny a player access to the chunk viewer");
        config.getTag("allowchunkviewer.DEFAULT").getBooleanValue(true);
        config.getTag("allowchunkviewer.OP").getBooleanValue(true);
        reloadDimensions = config.getTag("reload-dimensions").setComment("Set to false to disable the automatic reloading of mystcraft dimensions on server restart").getBooleanValue(true);
        opInteract = config.getTag("op-interact").setComment("Enabling this lets OPs alter other player's chunkloaders. WARNING: If you change a chunkloader, you have no idea what may break/explode by not being chunkloaded.").getBooleanValue(false);
        maxChunks = config.getTag("maxchunks").setComment("The maximum number of chunks per chunkloader").getIntValue(400);
        awayTimeout = config.getTag("awayTimeout").setComment("The number of minutes since last login within which chunks from a player will remain active, 0 for infinite.").getIntValue(0);
    }

    public static void addChunkLoader(IChickenChunkLoader loader) {
        int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
        ChunkLoaderOrganiser organiser = ChunkLoaderManager.getOrganiser(loader);
        if (organiser.canForceNewChunks(dim, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    private static ChunkLoaderOrganiser getOrganiser(IChickenChunkLoader loader) {
        String owner = loader.getOwner();
        World world = loader.getLoaderWorld();
        OrganiserStorage.IOrganiserStorage storage = OrganiserStorage.getStorage(world);
        return owner == null ? storage.getModOrganiser(loader.getMod()) : storage.getPlayerOrganiser(owner);
    }

    public static void remChunkLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).remChunkLoader(loader);
    }

    public static void updateLoader(IChickenChunkLoader loader) {
        ChunkLoaderManager.getOrganiser(loader).updateChunkLoader(loader);
    }

    public static boolean canLoaderAdd(IChickenChunkLoader loader, Collection<ChunkPos> chunks) {
        String owner = loader.getOwner();
        World world = loader.getLoaderWorld();
        int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
        return owner != null && OrganiserStorage.getStorage(world).getPlayerOrganiser(owner).canForceNewChunks(dim, (Collection)chunks);
    }

    public static void onServerShutdown() {
        loaded = false;
    }

    public static void onTickEnd(WorldServer world) {
        if (world.func_72820_D() % 1200L == 0L) {
            ChunkLoaderManager.updateLoginTimes((World)world);
        }
        OrganiserStorage.getStorage((World)world).tickUnloads();
        ChunkLoaderManager.processLoaderStates();
    }

    private static void updateLoginTimes(World world) {
        PlayerLoginTracker.ILoginTracker tracker = PlayerLoginTracker.getTracker(world);
        for (EntityPlayer player : ServerUtils.getPlayers()) {
            tracker.updateLoginTime(player.func_70005_c_());
        }
        tracker.forceSave(world);
        OrganiserStorage.IOrganiserStorage storage = OrganiserStorage.getStorage(world);
        storage.queDormantUnloads(world);
    }

    private static void processLoaderStates() {
        for (Object e : ReviveChange.PlayerRevive.list) {
            ((PlayerOrganiser)e).revive();
        }
        ReviveChange.PlayerRevive.list.clear();
        for (Object e : ReviveChange.ModRevive.list) {
            ((ModOrganiser)e).revive();
        }
        ReviveChange.ModRevive.list.clear();
        for (Object e : ReviveChange.DimensionRevive.list) {
            World world = (World)e;
            OrganiserStorage.getStorage(world).onDimensionRevive(world);
        }
        ReviveChange.DimensionRevive.list.clear();
        for (Object e : ReviveChange.PlayerDevive.list) {
            ((PlayerOrganiser)e).devive();
        }
        ReviveChange.PlayerDevive.list.clear();
    }

    public static int maxChunksPerLoader() {
        return maxChunks;
    }

    public static boolean canOpInteract() {
        return opInteract;
    }

    public static void onWorldUnload(World world) {
        OrganiserStorage.getStorage(world).onDimensionUnload(world);
    }

    private static BlockPos readPosition(NBTTagCompound tag) {
        int x = tag.func_74762_e("x");
        int y = tag.func_74762_e("y");
        int z = tag.func_74762_e("z");
        return new BlockPos(x, y, z);
    }

    private static NBTTagCompound writeBlockPos(BlockPos pos, NBTTagCompound tag) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    static {
        mods = new HashMap();
        loaded = false;
    }

    public static enum ReviveChange {
        PlayerRevive,
        PlayerDevive,
        ModRevive,
        DimensionRevive;

        public LinkedList<Object> list;

        public static void load() {
            for (ReviveChange change : ReviveChange.values()) {
                change.list = new LinkedList();
            }
        }
    }

    private static class DummyLoadingCallback
    implements ForgeChunkManager.OrderedLoadingCallback,
    ForgeChunkManager.PlayerOrderedLoadingCallback {
        private DummyLoadingCallback() {
        }

        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            return new LinkedList<ForgeChunkManager.Ticket>();
        }

        public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
            return LinkedListMultimap.create();
        }
    }

    public static class ModOrganiser
    extends ChunkLoaderOrganiser {
        public final Object mod;
        public final ModContainer container;
        public boolean dirty;

        public ModOrganiser(Object mod, ModContainer container) {
            this.mod = mod;
            this.container = container;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required < ForgeChunkManager.ticketCountAvailableFor((Object)this.mod, (World)DimensionManager.getWorld((int)dim)) * ForgeChunkManager.getMaxChunkDepthFor((String)this.container.getModId());
        }

        @Override
        public void setDirty() {
            this.dirty = false;
        }

        @Override
        protected ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestTicket((Object)this.mod, (World)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
    }

    public static class PlayerOrganiser
    extends ChunkLoaderOrganiser {
        public static boolean dirty;
        public final String username;

        public PlayerOrganiser(String username) {
            this.username = username;
        }

        @Override
        public boolean canForceNewChunks(int required, int dim) {
            return required + this.numLoadedChunks() < ChunkLoaderManager.getPlayerChunkLimit(this.username) && required < ForgeChunkManager.ticketCountAvailableFor((String)this.username) * ForgeChunkManager.getMaxChunkDepthFor((String)"ChickenChunks");
        }

        @Override
        public ForgeChunkManager.Ticket createTicket(int dimension) {
            return ForgeChunkManager.requestPlayerTicket((Object)ChickenChunks.instance, (String)this.username, (World)DimensionManager.getWorld((int)dimension), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }

        @Override
        public void setDirty() {
            dirty = true;
        }
    }

    private static abstract class ChunkLoaderOrganiser
    extends TicketManager {
        private HashMap<Integer, Set<BlockPos>> dormantLoaders = new HashMap();
        private HashMap<DimChunkCoord, List<IChickenChunkLoader>> forcedChunksByChunk = new HashMap();
        private HashMap<IChickenChunkLoader, Set<ChunkPos>> forcedChunksByLoader = new HashMap();
        private HashMap<DimChunkCoord, Integer> timedUnloadQueue = new HashMap();
        private boolean reviving;
        private boolean dormant = false;

        private ChunkLoaderOrganiser() {
        }

        public boolean canForceNewChunks(int dimension, Collection<ChunkPos> chunks) {
            if (this.dormant) {
                return true;
            }
            int required = 0;
            for (ChunkPos coord : chunks) {
                List<IChickenChunkLoader> loaders = this.forcedChunksByChunk.get(new DimChunkCoord(dimension, coord));
                if (loaders != null && !loaders.isEmpty()) continue;
                ++required;
            }
            return this.canForceNewChunks(required, dimension);
        }

        public final int numLoadedChunks() {
            return this.forcedChunksByChunk.size();
        }

        public void addChunkLoader(IChickenChunkLoader loader) {
            if (this.reviving) {
                return;
            }
            int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
            if (this.dormant) {
                Set coords = this.dormantLoaders.computeIfAbsent(dim, k -> new HashSet());
                coords.add(loader.getPosition());
            } else {
                this.forcedChunksByLoader.put(loader, new HashSet());
                this.forceChunks(loader, dim, loader.getChunks());
            }
            this.setDirty();
        }

        public void remChunkLoader(IChickenChunkLoader loader) {
            int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
            if (this.dormant) {
                Set<BlockPos> coords = this.dormantLoaders.get(dim);
                if (coords != null) {
                    coords.remove(loader.getPosition());
                }
            } else {
                Set<ChunkPos> chunks = this.forcedChunksByLoader.remove(loader);
                if (chunks == null) {
                    return;
                }
                this.unforceChunks(loader, dim, chunks, true);
            }
            this.setDirty();
        }

        private void unforceChunks(IChickenChunkLoader loader, int dim, Collection<ChunkPos> chunks, boolean remLoader) {
            for (ChunkPos coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                List<IChickenChunkLoader> loaders = this.forcedChunksByChunk.get(dimCoord);
                if (loaders == null || !loaders.remove(loader) || !loaders.isEmpty()) continue;
                this.forcedChunksByChunk.remove(dimCoord);
                this.timedUnloadQueue.put(dimCoord, 100);
            }
            if (!remLoader) {
                this.forcedChunksByLoader.get(loader).removeAll(chunks);
            }
            this.setDirty();
        }

        private void forceChunks(IChickenChunkLoader loader, int dim, Collection<ChunkPos> chunks) {
            for (ChunkPos coord : chunks) {
                DimChunkCoord dimCoord = new DimChunkCoord(dim, coord);
                List loaders = this.forcedChunksByChunk.computeIfAbsent(dimCoord, k -> new LinkedList());
                if (loaders.isEmpty()) {
                    this.timedUnloadQueue.remove(dimCoord);
                    this.addChunk(dimCoord);
                }
                if (loaders.contains(loader)) continue;
                loaders.add(loader);
            }
            this.forcedChunksByLoader.get(loader).addAll(chunks);
            this.setDirty();
        }

        public abstract boolean canForceNewChunks(int var1, int var2);

        public abstract void setDirty();

        public void updateChunkLoader(IChickenChunkLoader loader) {
            Set<ChunkPos> loaderChunks = this.forcedChunksByLoader.get(loader);
            if (loaderChunks == null) {
                this.addChunkLoader(loader);
                return;
            }
            HashSet<ChunkPos> oldChunks = new HashSet<ChunkPos>(loaderChunks);
            HashSet<ChunkPos> newChunks = new HashSet<ChunkPos>();
            for (ChunkPos chunk : loader.getChunks()) {
                if (oldChunks.remove(chunk)) continue;
                newChunks.add(chunk);
            }
            int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
            if (!oldChunks.isEmpty()) {
                this.unforceChunks(loader, dim, oldChunks, false);
            }
            if (!newChunks.isEmpty()) {
                this.forceChunks(loader, dim, newChunks);
            }
        }

        public NBTTagCompound saveToNBT(NBTTagCompound tagCompound) {
            NBTTagList dormantLoaders = new NBTTagList();
            for (Map.Entry<Integer, Set<BlockPos>> entry : this.dormantLoaders.entrySet()) {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("dim", entry.getKey().intValue());
                NBTTagList loaders = new NBTTagList();
                for (BlockPos pos : entry.getValue()) {
                    loaders.func_74742_a((NBTBase)ChunkLoaderManager.writeBlockPos(pos, new NBTTagCompound()));
                }
                nBTTagCompound.func_74782_a("loaders", (NBTBase)loaders);
                dormantLoaders.func_74742_a((NBTBase)nBTTagCompound);
            }
            tagCompound.func_74782_a("dormantLoaders", (NBTBase)dormantLoaders);
            NBTTagList loaders = new NBTTagList();
            for (IChickenChunkLoader iChickenChunkLoader : this.forcedChunksByLoader.keySet()) {
                NBTTagCompound loaderTag = new NBTTagCompound();
                loaderTag.func_74768_a("dim", CommonUtils.getDimension((World)iChickenChunkLoader.getLoaderWorld()));
                ChunkLoaderManager.writeBlockPos(iChickenChunkLoader.getPosition(), loaderTag);
                loaders.func_74742_a((NBTBase)loaderTag);
            }
            tagCompound.func_74782_a("loaders", (NBTBase)loaders);
            return tagCompound;
        }

        @Deprecated
        public void loadLegacyData(DataInputStream datain) throws IOException {
            int dimensions = datain.readInt();
            for (int i = 0; i < dimensions; ++i) {
                int dim = datain.readInt();
                HashSet<BlockPos> coords = new HashSet<BlockPos>();
                this.dormantLoaders.put(dim, coords);
                int numCoords = datain.readInt();
                for (int j = 0; j < numCoords; ++j) {
                    coords.add(new BlockPos(datain.readInt(), datain.readInt(), datain.readInt()));
                }
            }
            int numLoaders = datain.readInt();
            for (int i = 0; i < numLoaders; ++i) {
                int dim = datain.readInt();
                Set coords = this.dormantLoaders.computeIfAbsent(dim, k -> new HashSet());
                coords.add(new BlockPos(datain.readInt(), datain.readInt(), datain.readInt()));
            }
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagList dormantLoaders = nbt.func_150295_c("dormantLoaders", 10);
            for (int i = 0; i < dormantLoaders.func_74745_c(); ++i) {
                NBTTagCompound loader = dormantLoaders.func_150305_b(i);
                int dim = loader.func_74762_e("dim");
                Set loaderPositions = this.dormantLoaders.computeIfAbsent(dim, k -> new HashSet());
                NBTTagList loaders = loader.func_150295_c("loaders", 10);
                for (int j = 0; j < loaders.func_74745_c(); ++j) {
                    NBTTagCompound pos = loaders.func_150305_b(j);
                    loaderPositions.add(ChunkLoaderManager.readPosition(pos));
                }
            }
            NBTTagList loaders = nbt.func_150295_c("loaders", 10);
            for (int i = 0; i < loaders.func_74745_c(); ++i) {
                NBTTagCompound loader = loaders.func_150305_b(i);
                int dim = loader.func_74762_e("dim");
                Set positions = this.dormantLoaders.computeIfAbsent(dim, k -> new HashSet());
                positions.add(ChunkLoaderManager.readPosition(loader));
            }
        }

        public void revive() {
            if (!this.dormant) {
                return;
            }
            this.dormant = false;
            for (int dim : this.dormantLoaders.keySet()) {
                World world = ChunkLoaderManager.getWorld(dim, reloadDimensions);
                if (world == null) continue;
                this.revive(world);
            }
        }

        public void devive() {
            if (this.dormant) {
                return;
            }
            for (IChickenChunkLoader loader : new ArrayList<IChickenChunkLoader>(this.forcedChunksByLoader.keySet())) {
                int dim = CommonUtils.getDimension((World)loader.getLoaderWorld());
                Set coords = this.dormantLoaders.computeIfAbsent(dim, k -> new HashSet());
                coords.add(loader.getPosition());
                this.remChunkLoader(loader);
            }
            this.dormant = true;
        }

        public void revive(World world) {
            Set<BlockPos> coords = this.dormantLoaders.get(CommonUtils.getDimension((World)world));
            if (coords == null) {
                return;
            }
            ArrayList<BlockPos> verifyCoords = new ArrayList<BlockPos>(coords);
            coords.clear();
            for (BlockPos coord : verifyCoords) {
                this.reviving = true;
                TileEntity tile = world.func_175625_s(coord);
                this.reviving = false;
                if (!(tile instanceof IChickenChunkLoader)) continue;
                ChunkLoaderManager.addChunkLoader((IChickenChunkLoader)tile);
            }
        }

        public void setDormant() {
            this.dormant = true;
        }

        public boolean isDormant() {
            return this.dormant;
        }

        public void tickDownUnloads() {
            Iterator<Map.Entry<DimChunkCoord, Integer>> iterator = this.timedUnloadQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DimChunkCoord, Integer> entry = iterator.next();
                int ticks = entry.getValue();
                if (ticks <= 1) {
                    this.remChunk(entry.getKey());
                    iterator.remove();
                    continue;
                }
                entry.setValue(ticks - 1);
            }
        }
    }

    public static abstract class TicketManager {
        public HashMap<Integer, Stack<ForgeChunkManager.Ticket>> ticketsWithSpace = new HashMap();
        public HashMap<DimChunkCoord, ForgeChunkManager.Ticket> heldChunks = new HashMap();

        protected void addChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket;
            if (this.heldChunks.containsKey(coord)) {
                return;
            }
            Stack freeTickets = this.ticketsWithSpace.computeIfAbsent(coord.dimension, k -> new Stack());
            if (freeTickets.isEmpty()) {
                ticket = this.createTicket(coord.dimension);
                freeTickets.push(ticket);
            } else {
                ticket = (ForgeChunkManager.Ticket)freeTickets.peek();
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)coord.getChunkCoord());
            this.heldChunks.put(coord, ticket);
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() && !freeTickets.isEmpty()) {
                freeTickets.pop();
            }
        }

        protected abstract ForgeChunkManager.Ticket createTicket(int var1);

        protected void remChunk(DimChunkCoord coord) {
            ForgeChunkManager.Ticket ticket = this.heldChunks.remove(coord);
            if (ticket == null) {
                return;
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)coord.getChunkCoord());
            if (ticket.getChunkList().size() == ticket.getChunkListDepth() - 1) {
                Stack freeTickets = this.ticketsWithSpace.computeIfAbsent(coord.dimension, k -> new Stack());
                freeTickets.push(ticket);
            }
        }

        protected void unloadDimension(int dimension) {
            this.ticketsWithSpace.remove(dimension);
        }
    }

    private static class DimChunkCoord {
        public final int dimension;
        public final int chunkX;
        public final int chunkZ;

        public DimChunkCoord(int dim, ChunkPos coord) {
            this(dim, coord.field_77276_a, coord.field_77275_b);
        }

        public DimChunkCoord(int dim, int x, int z) {
            this.dimension = dim;
            this.chunkX = x;
            this.chunkZ = z;
        }

        public int hashCode() {
            return (this.chunkX * 31 + this.chunkZ) * 31 + this.dimension;
        }

        public boolean equals(Object o) {
            if (o instanceof DimChunkCoord) {
                DimChunkCoord o2 = (DimChunkCoord)o;
                return this.dimension == o2.dimension && this.chunkX == o2.chunkX && this.chunkZ == o2.chunkZ;
            }
            return false;
        }

        public ChunkPos getChunkCoord() {
            return new ChunkPos(this.chunkX, this.chunkZ);
        }
    }
}

