/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.GuiButtonHideable;
import com.enderio.core.client.gui.widget.GuiToolTip;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class TooltipButton
extends GuiButtonHideable {
    protected int xOrigin;
    protected int yOrigin;
    @Nonnull
    protected IGuiScreen gui;
    @Nullable
    protected String[] toolTipText;
    @Nullable
    protected GuiToolTip toolTip;

    public TooltipButton(@Nonnull IGuiScreen gui, int id, int x, int y, int widthIn, int heightIn, @Nonnull String buttonText) {
        super(id, x, y, widthIn, heightIn, buttonText);
        this.gui = gui;
        this.xOrigin = x;
        this.yOrigin = y;
    }

    public void setToolTip(String ... tooltipText) {
        if (this.toolTip != null) {
            this.toolTip.setToolTipText(tooltipText);
        } else {
            this.toolTip = new GuiToolTip(this.getBounds(), tooltipText);
        }
        this.toolTipText = tooltipText;
        this.updateTooltipBounds();
    }

    public void setToolTip(GuiToolTip newToolTip) {
        boolean addTooltip = false;
        if (this.toolTip != null) {
            addTooltip = this.gui.removeToolTip(this.toolTip);
        }
        this.toolTip = newToolTip;
        if (addTooltip && this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.updateTooltipBounds();
    }

    @Nonnull
    public final Rectangle getBounds() {
        return new Rectangle(this.xOrigin, this.yOrigin, this.getWidth(), this.getHeight());
    }

    public void onGuiInit() {
        this.gui.addGuiButton(this);
        if (this.toolTip != null) {
            this.gui.addToolTip(this.toolTip);
        }
        this.field_146128_h = this.xOrigin + this.gui.getGuiRootLeft();
        this.field_146129_i = this.yOrigin + this.gui.getGuiRootTop();
    }

    public void detach() {
        if (this.toolTip != null) {
            this.gui.removeToolTip(this.toolTip);
        }
        this.gui.removeButton(this);
    }

    public int getWidth() {
        return this.field_146120_f;
    }

    public int getHeight() {
        return this.field_146121_g;
    }

    @Nullable
    public GuiToolTip getToolTip() {
        return this.toolTip;
    }

    public void setSize(int width, int height) {
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.updateTooltipBounds();
    }

    public TooltipButton setPosition(int x, int y) {
        this.xOrigin = x;
        this.yOrigin = y;
        this.updateTooltipBounds();
        return this;
    }

    public void setXOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public void setYOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    private void updateTooltipBounds() {
        if (this.toolTip != null) {
            this.toolTip.setBounds(new Rectangle(this.xOrigin, this.yOrigin, this.field_146120_f, this.field_146121_g));
        }
    }

    protected void updateTooltip(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.toolTip != null) {
            this.toolTip.setIsVisible(this.field_146125_m && this.field_146124_l);
        }
    }

    protected final void doDrawButton(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.updateTooltip(mc, mouseX, mouseY);
        this.doDrawButton(mc, mouseX, mouseY, partialTicks);
    }
}

