/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.Part;
import thaumcraft.common.blocks.IBlockFacingHorizontal;
import thaumcraft.common.container.InventoryFake;
import thaumcraft.common.lib.crafting.Matrix;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.events.ToolEvents;
import thaumcraft.common.lib.utils.BlockUtils;

public class DustTriggerMultiblock
implements IDustTrigger {
    Part[][][] blueprint;
    String research;
    int ySize;
    int xSize;
    int zSize;

    public DustTriggerMultiblock(String research, Part[][][] blueprint) {
        this.blueprint = blueprint;
        this.research = research;
        this.ySize = this.blueprint.length;
        this.xSize = this.blueprint[0].length;
        this.zSize = this.blueprint[0][0].length;
    }

    @Override
    public IDustTrigger.Placement getValidFace(World world, EntityPlayer player, BlockPos pos, EnumFacing face) {
        if (this.research != null && !ThaumcraftCapabilities.getKnowledge(player).isResearchKnown(this.research)) {
            return null;
        }
        for (int yy = -this.ySize; yy <= 0; ++yy) {
            for (int xx = -this.xSize; xx <= 0; ++xx) {
                for (int zz = -this.zSize; zz <= 0; ++zz) {
                    BlockPos p2 = pos.func_177982_a(xx, yy, zz);
                    EnumFacing f = this.fitMultiblock(world, p2);
                    if (f == null) continue;
                    return new IDustTrigger.Placement(xx, yy, zz, f);
                }
            }
        }
        return null;
    }

    private EnumFacing fitMultiblock(World world, BlockPos pos) {
        block0: for (EnumFacing face : EnumFacing.field_176754_o) {
            for (int y = 0; y < this.ySize; ++y) {
                Matrix matrix2 = new Matrix(this.blueprint[y]);
                matrix2.Rotate90DegRight(3 - face.func_176736_b());
                for (int x = 0; x < matrix2.rows; ++x) {
                    for (int z = 0; z < matrix2.cols; ++z) {
                        if (matrix2.matrix[x][z] == null) continue;
                        IBlockState bsWo = world.func_180495_p(pos.func_177982_a(x, -y + (this.ySize - 1), z));
                        if (!(matrix2.matrix[x][z].getSource() instanceof Block && bsWo.func_177230_c() != matrix2.matrix[x][z].getSource() || matrix2.matrix[x][z].getSource() instanceof Material && bsWo.func_185904_a() != matrix2.matrix[x][z].getSource() || matrix2.matrix[x][z].getSource() instanceof ItemStack && (bsWo.func_177230_c() != Block.func_149634_a((Item)((ItemStack)matrix2.matrix[x][z].getSource()).func_77973_b()) || bsWo.func_177230_c().func_176201_c(bsWo) != ((ItemStack)matrix2.matrix[x][z].getSource()).func_77952_i()) || matrix2.matrix[x][z].getSource() instanceof IBlockState && bsWo != matrix2.matrix[x][z].getSource())) continue;
                        continue block0;
                    }
                }
            }
            return face;
        }
        return null;
    }

    @Override
    public List<BlockPos> sparkle(World world, EntityPlayer player, BlockPos pos, IDustTrigger.Placement placement) {
        BlockPos p2 = pos.func_177982_a(placement.xOffset, placement.yOffset, placement.zOffset);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int y = 0; y < this.ySize; ++y) {
            Matrix matrix2 = new Matrix(this.blueprint[y]);
            matrix2.Rotate90DegRight(3 - placement.facing.func_176736_b());
            for (int x = 0; x < matrix2.rows; ++x) {
                for (int z = 0; z < matrix2.cols; ++z) {
                    if (matrix2.matrix[x][z] == null) continue;
                    BlockPos p3 = p2.func_177982_a(x, -y + (this.ySize - 1), z);
                    if (matrix2.matrix[x][z].getSource() == null || !BlockUtils.isBlockExposed(world, p3)) continue;
                    list.add(p3);
                }
            }
        }
        return list;
    }

    @Override
    public void execute(final World world, final EntityPlayer player, BlockPos pos, IDustTrigger.Placement placement, EnumFacing side) {
        if (!world.field_72995_K) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, new ItemStack(BlocksTC.infernalFurnace), (IInventory)new InventoryFake(1));
            BlockPos p2 = pos.func_177982_a(placement.xOffset, placement.yOffset, placement.zOffset);
            for (int y = 0; y < this.ySize; ++y) {
                Matrix matrix2 = new Matrix(this.blueprint[y]);
                matrix2.Rotate90DegRight(3 - placement.facing.func_176736_b());
                for (int x = 0; x < matrix2.rows; ++x) {
                    for (int z = 0; z < matrix2.cols; ++z) {
                        ItemStack targetObject;
                        if (matrix2.matrix[x][z] == null || matrix2.matrix[x][z].getTarget() == null) continue;
                        if (matrix2.matrix[x][z].getTarget() instanceof Block) {
                            int meta = 0;
                            EnumFacing side2 = side;
                            if (matrix2.matrix[x][z].getTarget() instanceof IBlockFacingHorizontal) {
                                if (side2.func_176736_b() < 0) {
                                    side2 = player.func_174811_aO().func_176734_d();
                                }
                                IBlockState state = ((Block)matrix2.matrix[x][z].getTarget()).func_176223_P().func_177226_a((IProperty)IBlockFacingHorizontal.FACING, (Comparable)(matrix2.matrix[x][z].getApplyPlayerFacing() ? side2 : (matrix2.matrix[x][z].isOpp() ? placement.facing.func_176734_d() : placement.facing)));
                                meta = ((Block)matrix2.matrix[x][z].getTarget()).func_176201_c(state);
                            }
                            targetObject = new ItemStack((Block)matrix2.matrix[x][z].getTarget(), 1, meta);
                        } else {
                            targetObject = matrix2.matrix[x][z].getTarget() instanceof ItemStack ? ((ItemStack)matrix2.matrix[x][z].getTarget()).func_77946_l() : null;
                        }
                        final BlockPos p3 = p2.func_177982_a(x, -y + (this.ySize - 1), z);
                        final Object sourceObject = matrix2.matrix[x][z].getSource() instanceof Block ? world.func_180495_p(p3) : (matrix2.matrix[x][z].getSource() instanceof Material ? matrix2.matrix[x][z].getSource() : (matrix2.matrix[x][z].getSource() instanceof IBlockState ? matrix2.matrix[x][z].getSource() : null));
                        ToolEvents.addBlockedBlock(world, p3);
                        ServerEvents.addRunnableServer(world, new Runnable(){

                            @Override
                            public void run() {
                                ServerEvents.addSwapper(world, p3, sourceObject, targetObject, false, 0, player, true, false, -9999, false, false, 0, ServerEvents.DEFAULT_PREDICATE, 0.0f);
                                ToolEvents.clearBlockedBlock(world, p3);
                            }
                        }, matrix2.matrix[x][z].getPriority());
                    }
                }
            }
        }
    }
}

