/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.RayTraceResult;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;

public abstract class FocusNode
implements IFocusElement {
    FocusPackage pack;
    private FocusNode parent;
    HashMap<String, NodeSetting> settings = new HashMap();

    public FocusNode() {
        this.initialize();
    }

    public String getUnlocalizedName() {
        return this.getKey() + ".name";
    }

    public String getUnlocalizedText() {
        return this.getKey() + ".text";
    }

    public abstract int getComplexity();

    public abstract Aspect getAspect();

    public abstract EnumSupplyType[] mustBeSupplied();

    public abstract EnumSupplyType[] willSupply();

    public boolean canSupply(EnumSupplyType type) {
        if (this.willSupply() != null) {
            for (EnumSupplyType st : this.willSupply()) {
                if (st != type) continue;
                return true;
            }
        }
        return false;
    }

    public RayTraceResult[] supplyTargets() {
        return null;
    }

    public Trajectory[] supplyTrajectories() {
        return null;
    }

    public void setPackage(FocusPackage pack) {
        this.pack = pack;
    }

    public FocusPackage getPackage() {
        return this.pack;
    }

    public FocusPackage getRemainingPackage() {
        FocusPackage p = this.getPackage();
        List<IFocusElement> l = p.nodes.subList(p.index + 1, p.nodes.size());
        List<IFocusElement> l2 = Collections.synchronizedList(new ArrayList());
        for (IFocusElement fe : l) {
            l2.add(fe);
        }
        FocusPackage p2 = new FocusPackage();
        p2.setUniqueID(p.getUniqueID());
        p2.world = p.world;
        p2.multiplyPower(p.getPower());
        p2.nodes = l2;
        p2.setCasterUUID(p.getCasterUUID());
        return l2.isEmpty() ? null : p2;
    }

    public FocusNode getParent() {
        return this.parent;
    }

    public Set<String> getSettingList() {
        return this.settings.keySet();
    }

    public NodeSetting getSetting(String key) {
        return this.settings.get(key);
    }

    public int getSettingValue(String key) {
        return this.settings.containsKey(key) ? this.settings.get(key).getValue() : 0;
    }

    public NodeSetting[] createSettings() {
        return null;
    }

    public void initialize() {
        NodeSetting[] set = this.createSettings();
        if (set != null) {
            for (NodeSetting setting : set) {
                this.settings.put(setting.key, setting);
            }
        }
    }

    public void setParent(FocusNode parent) {
        this.parent = parent;
    }

    public float getPowerMultiplier() {
        return 1.0f;
    }

    public boolean isExclusive() {
        return false;
    }

    public static enum EnumSupplyType {
        TARGET,
        TRAJECTORY;

    }
}

