/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.enums.HugeLilypadPiece;
import twilightforest.item.TFItems;

public class BlockTFHugeLilyPad
extends BlockBush
implements ModelRegisterCallback {
    public static final IProperty<EnumFacing> FACING = BlockHorizontal.field_185512_D;
    public static final IProperty<HugeLilypadPiece> PIECE = PropertyEnum.func_177709_a((String)"piece", HugeLilypadPiece.class);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.015625, 1.0);
    private boolean isSelfDestructing = false;

    protected BlockTFHugeLilyPad() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH).func_177226_a(PIECE, (Comparable)((Object)HugeLilypadPiece.NW)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PIECE});
    }

    public int func_176201_c(IBlockState state) {
        return (((EnumFacing)state.func_177229_b(FACING)).func_176736_b() | ((HugeLilypadPiece)((Object)state.func_177229_b(PIECE))).ordinal() << 2) & 0xF;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_176731_b((int)((meta &= 0xF) & 3))).func_177226_a(PIECE, (Comparable)((Object)HugeLilypadPiece.values()[(meta & 0xC) >> 2]));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150355_j;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!this.isSelfDestructing) {
            this.setGiantBlockToAir(world, pos, state);
        }
    }

    private void setGiantBlockToAir(World world, BlockPos pos, IBlockState state) {
        this.isSelfDestructing = true;
        for (BlockPos check : this.getAllMyBlocks(pos, state)) {
            IBlockState stateThere = world.func_180495_p(check);
            if (stateThere.func_177230_c() != this) continue;
            world.func_175655_b(check, false);
        }
        this.isSelfDestructing = false;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        for (BlockPos check : this.getAllMyBlocks(pos, state)) {
            IBlockState dStateBelow = world.func_180495_p(check.func_177977_b());
            if (dStateBelow.func_177230_c() != Blocks.field_150355_j && dStateBelow.func_177230_c() != Blocks.field_150358_i || (Integer)dStateBelow.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                return false;
            }
            if (world.func_180495_p(check).func_177230_c() == this) continue;
            return false;
        }
        return true;
    }

    public List<BlockPos> getAllMyBlocks(BlockPos pos, IBlockState state) {
        ArrayList pieces = Lists.newArrayListWithCapacity((int)4);
        if (state.func_177230_c() == this) {
            BlockPos nwPos = pos;
            switch ((HugeLilypadPiece)((Object)state.func_177229_b(PIECE))) {
                case NE: {
                    nwPos = nwPos.func_177976_e();
                    break;
                }
                case SE: {
                    nwPos = nwPos.func_177978_c().func_177976_e();
                    break;
                }
                case SW: {
                    nwPos = nwPos.func_177978_c();
                    break;
                }
            }
            pieces.add(nwPos);
            pieces.add(nwPos.func_177968_d());
            pieces.add(nwPos.func_177974_f());
            pieces.add(nwPos.func_177968_d().func_177974_f());
        }
        return pieces;
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!(entityIn instanceof EntityBoat)) {
            BlockTFHugeLilyPad.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityBoat) {
            worldIn.func_175655_b(new BlockPos((Vec3i)pos), true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

