/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.enums.FireJetVariant;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFFlameJet;
import twilightforest.tileentity.TileEntityTFPoppingJet;
import twilightforest.tileentity.TileEntityTFSmoker;

public class BlockTFFireJet
extends Block
implements ModelRegisterCallback {
    public static final IProperty<FireJetVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", FireJetVariant.class);
    private static final Set<FireJetVariant> ENCASED = EnumSet.of(FireJetVariant.ENCASED_JET_IDLE, FireJetVariant.ENCASED_JET_FLAME, FireJetVariant.ENCASED_SMOKER_OFF, FireJetVariant.ENCASED_SMOKER_ON, FireJetVariant.ENCASED_JET_POPPING);

    protected BlockTFFireJet() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(TFItems.creativeTab);
        this.func_149675_a(true);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        FireJetVariant[] values = FireJetVariant.values();
        FireJetVariant variant = values[meta % values.length];
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant));
    }

    public int func_176201_c(IBlockState state) {
        return ((FireJetVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        switch ((FireJetVariant)((Object)state.func_177229_b(VARIANT))) {
            case ENCASED_SMOKER_ON: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_SMOKER_OFF));
                break;
            }
            case ENCASED_JET_POPPING: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_JET_IDLE));
                break;
            }
            case ENCASED_JET_FLAME: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_JET_IDLE));
                break;
            }
            case JET_POPPING: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.JET_IDLE));
                break;
            }
            case JET_FLAME: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.JET_IDLE));
                break;
            }
        }
        return this.func_176201_c(state);
    }

    public Material func_149688_o(IBlockState state) {
        return ENCASED.contains(state.func_177229_b(VARIANT)) ? Material.field_151575_d : Material.field_151576_e;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ENCASED.contains(state.func_177229_b(VARIANT)) ? MapColor.field_151658_d : MapColor.field_151661_c;
    }

    public int func_149750_m(IBlockState state) {
        switch ((FireJetVariant)((Object)state.func_177229_b(VARIANT))) {
            case ENCASED_JET_FLAME: 
            case JET_FLAME: {
                return 15;
            }
        }
        return 0;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((FireJetVariant)((Object)state.func_177229_b(VARIANT))) {
            case ENCASED_JET_POPPING: 
            case JET_POPPING: {
                return PathNodeType.DANGER_FIRE;
            }
            case ENCASED_JET_FLAME: 
            case JET_FLAME: {
                return PathNodeType.DAMAGE_FIRE;
            }
        }
        return null;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        BlockPos lavaPos;
        if (!world.field_72995_K && state.func_177229_b(VARIANT) == FireJetVariant.JET_IDLE && this.isLava(world, lavaPos = this.findLavaAround(world, pos.func_177977_b()))) {
            world.func_175656_a(lavaPos, Blocks.field_150350_a.func_176223_P());
            world.func_180501_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.JET_POPPING)), 2);
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block myBlockID, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        FireJetVariant variant = (FireJetVariant)((Object)state.func_177229_b(VARIANT));
        boolean powered = world.func_175640_z(pos);
        if (variant == FireJetVariant.ENCASED_SMOKER_OFF && powered) {
            world.func_180501_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_SMOKER_ON)), 3);
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
        if (variant == FireJetVariant.ENCASED_SMOKER_ON && !powered) {
            world.func_180501_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_SMOKER_OFF)), 3);
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
        if (variant == FireJetVariant.ENCASED_JET_IDLE && powered) {
            world.func_180501_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)FireJetVariant.ENCASED_JET_POPPING)), 3);
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private BlockPos findLavaAround(World world, BlockPos pos) {
        if (this.isLava(world, pos)) {
            return pos;
        }
        for (int i = 0; i < 3; ++i) {
            BlockPos randPos = pos.func_177982_a(world.field_73012_v.nextInt(3) - 1, 0, world.field_73012_v.nextInt(3) - 1);
            if (!this.isLava(world, randPos)) continue;
            return randPos;
        }
        return pos;
    }

    private boolean isLava(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        PropertyInteger levelProp = b instanceof BlockLiquid || b instanceof BlockFluidBase ? BlockLiquid.field_176367_b : null;
        return state.func_185904_a() == Material.field_151587_i && (levelProp == null || (Integer)state.func_177229_b((IProperty)levelProp) == 0);
    }

    public boolean hasTileEntity(IBlockState state) {
        switch ((FireJetVariant)((Object)state.func_177229_b(VARIANT))) {
            case ENCASED_SMOKER_ON: 
            case ENCASED_JET_POPPING: 
            case ENCASED_JET_FLAME: 
            case JET_POPPING: 
            case JET_FLAME: 
            case SMOKER: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((FireJetVariant)((Object)state.func_177229_b(VARIANT))) {
            case ENCASED_SMOKER_ON: 
            case SMOKER: {
                return new TileEntityTFSmoker();
            }
            case JET_POPPING: {
                return new TileEntityTFPoppingJet(FireJetVariant.JET_FLAME);
            }
            case JET_FLAME: {
                return new TileEntityTFFlameJet(FireJetVariant.JET_IDLE);
            }
            case ENCASED_JET_POPPING: {
                return new TileEntityTFPoppingJet(FireJetVariant.ENCASED_JET_FLAME);
            }
            case ENCASED_JET_FLAME: {
                return new TileEntityTFFlameJet(FireJetVariant.ENCASED_JET_IDLE);
            }
        }
        return null;
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, FireJetVariant.SMOKER.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, FireJetVariant.JET_IDLE.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, FireJetVariant.ENCASED_SMOKER_OFF.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, FireJetVariant.ENCASED_JET_IDLE.ordinal()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        FireJetVariant[] variants;
        for (FireJetVariant variant : variants = new FireJetVariant[]{FireJetVariant.SMOKER, FireJetVariant.JET_IDLE, FireJetVariant.ENCASED_SMOKER_OFF, FireJetVariant.ENCASED_JET_IDLE}) {
            ModelUtils.registerToState(this, variant.ordinal(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)));
        }
    }
}

