/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.recipes;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;
import reborncore.common.recipes.IRecipeInput;

public class OreRecipeInput
implements IRecipeInput {
    String oreDictName;
    int size = 1;

    public OreRecipeInput(String oreDictName, int size) {
        this.oreDictName = oreDictName;
        this.size = size;
        Validate.notEmpty(this.getAllStacks());
    }

    public OreRecipeInput(String oreDictName) {
        this.oreDictName = oreDictName;
        Validate.notEmpty(this.getAllStacks());
    }

    @Override
    public ItemStack getItemStack() {
        List<ItemStack> list = this.getAllStacks();
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return list.get(0);
    }

    @Override
    public List<ItemStack> getAllStacks() {
        if (!OreDictionary.doesOreNameExist((String)this.oreDictName)) {
            return NonNullList.func_191196_a();
        }
        NonNullList list = OreDictionary.getOres((String)this.oreDictName);
        return list.stream().filter(Objects::nonNull).map(stack -> {
            ItemStack clone = stack.func_77946_l();
            clone.func_190920_e(this.size);
            return clone;
        }).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }
}

