/*
 * Decompiled with CFR 0.152.
 */
package presents.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import presents.common.block.BlockPresentEmpty;
import presents.common.tileentity.TileEntityPresent;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockPresent
extends BlockPresentEmpty
implements ITileEntityProvider {
    public BlockPresent(String name) {
        super(name);
        this.field_149758_A = true;
        this.boundingBox = new AxisAlignedBB(0.15625, 0.0, 0.15625, 0.84375, 0.6875, 0.84375);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag tooltipFlag) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("BlockEntityTag")) {
            NBTTagCompound blockEntityTag = tagCompound.func_74775_l("BlockEntityTag");
            if (blockEntityTag.func_74764_b("LootTable") || !blockEntityTag.func_74779_i("PlayerName").equals(Minecraft.func_71410_x().field_71439_g.getDisplayNameString())) {
                tooltip.add("???????");
            } else {
                if (blockEntityTag.func_74764_b("Items")) {
                    NonNullList inventory = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
                    ItemStackHelper.func_191283_b((NBTTagCompound)blockEntityTag, (NonNullList)inventory);
                    tooltip.add(I18n.func_74838_a((String)"presents:container.present.contents"));
                    for (ItemStack inventoryStack : inventory) {
                        if (inventoryStack.func_190926_b()) continue;
                        tooltip.add("  " + inventoryStack.func_82833_r());
                    }
                }
                if (blockEntityTag.func_74764_b("Explosion")) {
                    tooltip.add(I18n.func_74838_a((String)"presents:container.present.explosion"));
                    ArrayList list = Lists.newArrayList();
                    ItemFireworkCharge.func_150902_a((NBTTagCompound)blockEntityTag.func_74775_l("Explosion"), (List)list);
                    if (!list.isEmpty()) {
                        for (int j = 0; j < list.size(); ++j) {
                            list.set(j, "  " + (String)list.get(j));
                        }
                        tooltip.addAll(list);
                    }
                }
                tooltip.add(TextFormatting.ITALIC + I18n.func_74838_a((String)"presents:container.present.ownerinfo"));
            }
        }
        super.func_190948_a(stack, world, tooltip, tooltipFlag);
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPresent();
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return super.getExpDrop(state, world, pos, fortune);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityPresent) {
            ((TileEntityPresent)tileEntity).spawnItems(null);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityPresent) {
            return ((TileEntityPresent)tileEntity).makeFireworks();
        }
        return false;
    }
}

