/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.wireless;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collector;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ConfigOptions {
    public static int Range = 40;
    public static int TransferRate = 30000;
    public static int Capacity = 3000000;
    public static Set<ResourceLocation> BlacklistedItems = Collections.unmodifiableSet(Arrays.stream(new String[]{"thermalexpansion:cell"}).collect(ConfigOptions.toResourceLocations()));
    public static ResourceLocation UpgradeItem;

    public static void loadConfig(File file) {
        Configuration config = new Configuration(file);
        Range = config.getInt("Range", "general", 40, 1, 10000, "Players in this radius will get their charged.");
        TransferRate = config.getInt("TransferRate", "general", 30000, 1, 1000000000, "Energy transfer rate per item.");
        Capacity = config.getInt("Capacity", "general", 3000000, 1, 1000000000, "Max energy can be stored.");
        BlacklistedItems = Collections.unmodifiableSet(Arrays.stream(config.getStringList("BlacklistedItems", "general", new String[]{"thermalexpansion:cell"}, "These items will not be charged.")).collect(ConfigOptions.toResourceLocations()));
        UpgradeItem = new ResourceLocation(config.getString("UpgradeItem", "general", "minecraft:nether_star", "The item required to upgrade a WirelessCharger, set to minecraft:air if you want to disable it, existing ones will not change"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static Collector<String, ?, Set<ResourceLocation>> toResourceLocations() {
        return Collector.of(HashSet::new, (r, e) -> r.add(new ResourceLocation(e)), (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        }, new Collector.Characteristics[0]);
    }
}

