/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Random;

public enum Spawner {
    CREEPER("creeper"),
    CAVESPIDER("cave_spider"),
    SPIDER("spider"),
    SKELETON("skeleton"),
    ZOMBIE("zombie"),
    SILVERFISH("silverfish"),
    ENDERMAN("enderman"),
    WITCH("witch"),
    WITHERBOSS("wither"),
    WITHER("wither_skeleton"),
    BAT("bat"),
    LAVASLIME("magma_cube"),
    BLAZE("blaze"),
    SLIME("slime"),
    PRIMEDTNT("tnt"),
    PIGZOMBIE("zombie_pigman");

    private String name;
    private static final Spawner[] common;

    private Spawner(String name) {
        this.name = name;
    }

    public static String getName(Spawner type) {
        return "minecraft:" + type.name;
    }

    public static void generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord cursor) {
        Spawner type = common[rand.nextInt(common.length)];
        Spawner.generate(editor, rand, settings, cursor, type);
    }

    public static void generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord cursor, Spawner type) {
        int difficulty = settings.getDifficulty(cursor);
        SpawnerSettings spawners = settings.getSpawners();
        if (spawners == null) {
            new Spawnable(type).generate(editor, rand, cursor, difficulty);
            return;
        }
        spawners.generate(editor, rand, cursor, type, difficulty);
    }

    static {
        common = new Spawner[]{SPIDER, SKELETON, ZOMBIE};
    }
}

