/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.DungeonStage;
import greymerk.roguelike.dungeon.IDungeon;
import greymerk.roguelike.dungeon.IDungeonLevel;
import greymerk.roguelike.dungeon.settings.ISettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.tasks.IDungeonTask;
import greymerk.roguelike.dungeon.tasks.IDungeonTaskRegistry;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.List;
import java.util.Random;

public class DungeonGenerator {
    public static void generate(IWorldEditor editor, IDungeon dungeon, ISettings settings, IDungeonTaskRegistry tasks) {
        Coord start = dungeon.getPosition();
        Random rand = Dungeon.getRandom(editor, start);
        List<IDungeonLevel> levels = dungeon.getLevels();
        int numLevels = settings.getNumLevels();
        for (int i = 0; i < numLevels; ++i) {
            LevelSettings levelSettings = settings.getLevelSettings(i);
            DungeonLevel level = new DungeonLevel(editor, rand, levelSettings, new Coord(start));
            levels.add(level);
        }
        for (DungeonStage stage : DungeonStage.values()) {
            for (IDungeonTask task : tasks.getTasks(stage)) {
                task.execute(editor, rand, dungeon, settings);
            }
        }
    }
}

