/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.utils;

public enum Tiers {
    LEVEL1(1000, "(1K Items) (Lvl 1)", 2, 1, 10, 64, 0.0f, 1.0f, 0.0f, 1.0f),
    LEVEL2(10000, "(10K Items) (Lvl 2)", 3, 2, 100, 1000, 1.0f, 0.0f, 0.0f, 1.0f),
    LEVEL3(100000, "(100K Items) (Lvl 3)", 4, 3, 1000, 10000, 0.3333f, 1.0f, 1.0f, 1.0f),
    LEVEL4(1000000, "(1M Items) (Lvl 4)", 5, 4, 10000, 10000, 0.8f, 0.2f, 0.8f, 1.0f),
    LEVEL5(1000000000, "(1B Items) (Lvl 5)", 8, 5, 1000000, 10000, 1.0f, 0.55f, 0.0f, 1.0f);

    private final int maxStorage;
    private final int machineSlots;
    private final int fluidSlots;
    private final int energyStorage;
    private final int fluidCapacity;
    private final String label;
    private final float r;
    private final float g;
    private final float b;
    private final float alpha;

    private Tiers(int maxStorage, String label, int machineSlots, int fluidSlots, int energyStorage, int fluidCapacity, float r, float g, float b, float alpha) {
        this.maxStorage = maxStorage;
        this.label = label;
        this.machineSlots = machineSlots;
        this.fluidSlots = fluidSlots;
        this.energyStorage = energyStorage;
        this.fluidCapacity = fluidCapacity;
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public int getMaxStorage() {
        return this.maxStorage;
    }

    public int getFluidSlots() {
        return this.fluidSlots;
    }

    public int getFluidCapacity() {
        return this.fluidCapacity;
    }

    public int getEnergyStorage() {
        return this.energyStorage;
    }

    public int getMachineSlots() {
        return this.machineSlots * this.machineSlots;
    }

    public String getLabel() {
        return this.label;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int getColor() {
        int red = (int)(this.r * 255.0f);
        int green = (int)(this.g * 255.0f);
        int blue = (int)(this.b * 255.0f);
        int alpha = (int)(this.alpha * 255.0f);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

