/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.hud;

import WayofTime.bloodmagic.client.Sprite;
import WayofTime.bloodmagic.client.hud.ElementRegistry;
import WayofTime.bloodmagic.client.hud.element.ElementDemonAura;
import WayofTime.bloodmagic.client.hud.element.ElementDivinedInformation;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.tile.TileIncenseAltar;
import WayofTime.bloodmagic.tile.TileInversionPillar;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Vector2f;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class Elements {
    public static void registerElements() {
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "blood_altar"), new ElementDivinedInformation<TileAltar>(2, true, TileAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 46, 16, 16), altar -> altar == null ? "IV" : NumeralHelper.toRoman(altar.getTier().toInt())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 16, 46, 16, 16), altar -> String.format("%d/%d", altar == null ? 0 : altar.getCurrentBlood(), altar == null ? 10000 : altar.getCapacity())));
            }
        }, new Vector2f(0.01f, 0.01f));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "blood_altar_adv"), new ElementDivinedInformation<TileAltar>(5, false, TileAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 46, 16, 16), altar -> altar == null ? "IV" : NumeralHelper.toRoman(altar.getTier().toInt())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 16, 46, 16, 16), altar -> String.format("%d/%d", altar == null ? 0 : altar.getCurrentBlood(), altar == null ? 10000 : altar.getCapacity())));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 32, 46, 16, 16), altar -> {
                    if (altar == null || !altar.isActive()) {
                        return I18n.func_135052_a((String)"hud.bloodmagic.inactive", (Object[])new Object[0]);
                    }
                    int progress = altar.getProgress();
                    int totalLiquidRequired = altar.getLiquidRequired() * altar.func_70301_a(0).func_190916_E();
                    return String.format("%d/%d", progress, totalLiquidRequired);
                }));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 48, 46, 16, 16), altar -> altar == null ? "0" : String.valueOf((int)(altar.getConsumptionRate() * (altar.getConsumptionMultiplier() + 1.0f)))));
                information.accept((Pair<Sprite, Function<TileAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 64, 46, 16, 16), altar -> altar == null ? "0" : String.valueOf(altar.getTotalCharge())));
            }
        }, new Vector2f(0.01f, 0.01f));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "incense_altar"), new ElementDivinedInformation<TileIncenseAltar>(2, true, TileIncenseAltar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileIncenseAltar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileIncenseAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 80, 46, 16, 16), incense -> incense == null ? "0" : String.valueOf((int)(100.0 * (double)((int)(100.0 * incense.tranquility)) / 100.0))));
                information.accept((Pair<Sprite, Function<TileIncenseAltar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 96, 46, 16, 16), incense -> incense == null ? "0" : String.valueOf((int)(100.0 * incense.incenseAddition))));
            }
        }, new Vector2f(0.01f, 0.01f));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "inversion_pillar"), new ElementDivinedInformation<TileInversionPillar>(1, true, TileInversionPillar.class){

            @Override
            public void gatherInformation(Consumer<Pair<Sprite, Function<TileInversionPillar, String>>> information) {
                information.accept((Pair<Sprite, Function<TileInversionPillar, String>>)Pair.of((Object)new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 112, 46, 16, 16), pillar -> pillar == null ? "0" : String.valueOf((double)((int)(10.0 * pillar.getCurrentInversion())) / 10.0)));
            }
        }, new Vector2f(0.01f, 0.01f));
        ElementRegistry.registerHandler(new ResourceLocation("bloodmagic", "demon_will_aura"), new ElementDemonAura(), new Vector2f(0.01f, 0.01f));
        ElementRegistry.readConfig();
    }
}

