/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.InputStream;
import java.net.URL;
import javassist.ClassPath;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;

public class ClassClassPath
implements ClassPath {
    private static final boolean useJigsaw = ClassFile.MAJOR_VERSION >= 53;
    private Class thisClass;

    public ClassClassPath(Class c) {
        this.thisClass = c;
    }

    ClassClassPath() {
        this(Object.class);
    }

    @Override
    public InputStream openClassfile(String classname) throws NotFoundException {
        String filename = '/' + classname.replace('.', '/') + ".class";
        return this.thisClass.getResourceAsStream(filename);
    }

    @Override
    public URL find(String classname) {
        String filename = '/' + classname.replace('.', '/') + ".class";
        return this.thisClass.getResource(filename);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.thisClass.getName() + ".class";
    }
}

