/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.postfix;

import com.google.common.collect.PeekingIterator;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.utils.Stack;

public abstract class PostfixParser<E> {
    public E parse(PeekingIterator<Token> input) {
        Stack<IPostfixParserState<IPostfixParserState<E>>> stateStack = Stack.create();
        stateStack.push(this.createInitialState());
        block4: while (input.hasNext()) {
            Token token = (Token)input.next();
            if (token.type == TokenType.MODIFIER) {
                stateStack.push(this.createStateForModifier(token.value));
                continue;
            }
            if (token.type == TokenType.LEFT_BRACKET) {
                stateStack.push(this.createStateForBracket(token.value));
                continue;
            }
            IPostfixParserState currentState = (IPostfixParserState)stateStack.peek(0);
            IPostfixParserState.Result result = currentState.acceptToken(token);
            switch (result) {
                case ACCEPTED_AND_FINISHED: {
                    this.unwindStack(stateStack);
                }
                case ACCEPTED: {
                    continue block4;
                }
            }
            throw new IllegalStateException("Token  " + token + " not accepted in state " + currentState);
        }
        IPostfixParserState finalState = (IPostfixParserState)stateStack.popAndExpectEmptyStack();
        return finalState.getResult();
    }

    private void unwindStack(Stack<IPostfixParserState<E>> stateStack) {
        IPostfixParserState<E> currentState = stateStack.pop();
        block4: while (true) {
            E exitResult = currentState.getResult();
            currentState = stateStack.peek(0);
            IPostfixParserState.Result acceptResult = currentState.acceptChildResult(exitResult);
            switch (acceptResult) {
                case ACCEPTED_AND_FINISHED: {
                    stateStack.pop();
                    continue block4;
                }
                case ACCEPTED: {
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Executable  " + exitResult + " not accepted in state " + currentState);
                }
            }
            break;
        }
    }

    protected abstract IPostfixParserState<E> createInitialState();

    protected IPostfixParserState<E> createStateForModifier(String modifier) {
        throw new UnsupportedOperationException(modifier);
    }

    protected IPostfixParserState<E> createStateForBracket(String bracket) {
        throw new UnsupportedOperationException(bracket);
    }
}

