/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.executable;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.executable.Operator;
import info.openmods.calc.parsing.ast.OperatorArity;
import info.openmods.calc.symbol.SymbolMap;
import info.openmods.calc.utils.Stack;

public abstract class UnaryOperator<E>
extends Operator<E> {
    private UnaryOperator(String id, int precendence) {
        super(id, precendence);
    }

    @Override
    public OperatorArity arity() {
        return OperatorArity.UNARY;
    }

    @Override
    public boolean isLowerPriority(Operator<E> other) {
        return this.precedence < other.precedence;
    }

    public String toString() {
        return "UnaryOperator [" + this.id + "]";
    }

    public static abstract class StackBased<E>
    extends UnaryOperator<E> {
        public StackBased(String id, int precendence) {
            super(id, precendence);
        }

        public StackBased(String id) {
            this(id, Integer.MAX_VALUE);
        }

        public abstract void executeOnStack(Frame<E> var1);

        @Override
        public final void execute(Frame<E> frame) {
            Frame<E> executionFrame = FrameFactory.newLocalFrameWithSubstack(frame, 1);
            this.executeOnStack(executionFrame);
            executionFrame.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Scoped<E>
    extends UnaryOperator<E> {
        public Scoped(String id, int precendence) {
            super(id, precendence);
        }

        public Scoped(String id) {
            this(id, Integer.MAX_VALUE);
        }

        public abstract E execute(SymbolMap<E> var1, E var2);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E value = stack.pop();
            E result = this.execute(frame.symbols(), value);
            stack.push(result);
        }
    }

    public static abstract class Direct<E>
    extends UnaryOperator<E> {
        public Direct(String id, int precendence) {
            super(id, precendence);
        }

        public Direct(String id) {
            this(id, Integer.MAX_VALUE);
        }

        public abstract E execute(E var1);

        @Override
        public final void execute(Frame<E> frame) {
            Stack<E> stack = frame.stack();
            E value = stack.pop();
            E result = this.execute(value);
            stack.push(result);
        }
    }
}

