/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.mutable_loot;

import com.google.common.base.Functions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import leviathan143.loottweaker.common.darkmagic.LootPoolAccessors;
import leviathan143.loottweaker.common.darkmagic.LootTableManagerAccessors;
import leviathan143.loottweaker.common.lib.DeepClone;
import leviathan143.loottweaker.common.mutable_loot.entry.MutableLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class MutableLootPool
implements DeepClone<MutableLootPool> {
    private final String name;
    private Map<String, MutableLootEntry<?, ?>> entries;
    private List<LootCondition> conditions;
    private RandomValueRange rolls;
    private RandomValueRange bonusRolls;

    MutableLootPool(LootPool pool) {
        this.name = pool.getName();
        BinaryOperator mergeFunction = (a, b) -> {
            throw new IllegalStateException(String.format("Unexpected duplicate entry '%s' while creating mutable pool '%s' from immutable pool. Report this to the mod author", a.getName(), this.getName()));
        };
        this.entries = LootPoolAccessors.getEntries(pool).stream().map(MutableLootEntry::from).collect(Collectors.toMap(MutableLootEntry::getName, Functions.identity(), mergeFunction, HashMap::new));
        this.conditions = LootPoolAccessors.getConditions(pool);
        this.rolls = pool.getRolls();
        this.bonusRolls = pool.getBonusRolls();
    }

    public MutableLootPool(String name, Map<String, MutableLootEntry<?, ?>> entries, List<LootCondition> conditions, RandomValueRange rolls, RandomValueRange bonusRolls) {
        this.name = name;
        this.entries = entries;
        this.conditions = conditions;
        this.rolls = rolls;
        this.bonusRolls = bonusRolls;
    }

    @Override
    public MutableLootPool deepClone() {
        BinaryOperator mergeFunction = (a, b) -> {
            throw new IllegalStateException(String.format("Unexpected duplicate entry '%s' while deep cloning mutable pool '%s'. Report this to the mod author", a.getName(), this.getName()));
        };
        Map entriesDeepClone = this.entries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (MutableLootEntry)((MutableLootEntry)e.getValue()).deepClone(), mergeFunction, HashMap::new));
        return new MutableLootPool(this.name, entriesDeepClone, this.deepCloneConditions(), this.rolls, this.bonusRolls);
    }

    private List<LootCondition> deepCloneConditions() {
        ArrayList<LootCondition> clone = new ArrayList<LootCondition>(this.conditions.size());
        for (int i = 0; i < this.conditions.size(); ++i) {
            clone.add(this.deepCloneCondition(this.conditions.get(i)));
        }
        return clone;
    }

    private LootCondition deepCloneCondition(LootCondition lootCondition) {
        Gson lootTableGson = LootTableManagerAccessors.getGsonInstance();
        JsonElement json = lootTableGson.toJsonTree((Object)lootCondition);
        return (LootCondition)lootTableGson.fromJson(json, LootCondition.class);
    }

    public LootPool toImmutable() {
        LootEntry[] entriesArray = (LootEntry[])this.entries.values().stream().map(MutableLootEntry::toImmutable).toArray(LootEntry[]::new);
        return new LootPool(entriesArray, this.conditions.toArray(new LootCondition[0]), this.rolls, this.bonusRolls, this.name);
    }

    public List<LootCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<LootCondition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(LootCondition condition) {
        this.conditions.add(condition);
    }

    public void addConditions(List<LootCondition> newConditions) {
        this.conditions.addAll(newConditions);
    }

    public void clearConditions() {
        this.conditions.clear();
    }

    public RandomValueRange getRolls() {
        return this.rolls;
    }

    public void setRolls(RandomValueRange rolls) {
        this.rolls = rolls;
    }

    public RandomValueRange getBonusRolls() {
        return this.bonusRolls;
    }

    public void setBonusRolls(RandomValueRange bonusRolls) {
        this.bonusRolls = bonusRolls;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, MutableLootEntry<?, ?>> getEntries() {
        return this.entries;
    }

    public MutableLootEntry<?, ?> getEntry(String name) {
        return this.entries.get(name);
    }

    public void addEntry(MutableLootEntry<?, ?> entry) {
        if (this.entries.putIfAbsent(entry.getName(), entry) != null) {
            throw new IllegalArgumentException(String.format("Duplicate entry name '%s' in pool '%s'", entry.getName(), this.getName()));
        }
    }

    public MutableLootEntry<?, ?> removeEntry(String name) {
        return this.entries.remove(name);
    }

    public void clearEntries() {
        this.entries.clear();
    }
}

