/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableFinder {
    public static final LootTableFinder DEFAULT = new LootTableFinder();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<ResourceLocation> validIds = new HashSet<ResourceLocation>(LootTableList.func_186374_a());
    private boolean fullScanPerformed = false;

    public boolean exists(ResourceLocation tableId) {
        if (this.validIds.contains(tableId)) {
            return true;
        }
        String assetLocation = "assets/" + tableId.func_110624_b() + "/loot_tables/" + tableId.func_110623_a() + ".json";
        if (this.getClass().getClassLoader().getResource(assetLocation) != null) {
            this.add(tableId);
            return true;
        }
        return false;
    }

    private boolean add(ResourceLocation tableId) {
        return this.validIds.add(tableId);
    }

    public boolean fullScanPerformed() {
        return this.fullScanPerformed;
    }

    public Iterable<ResourceLocation> findAll() {
        if (!this.fullScanPerformed) {
            LOGGER.info("Locating all existing loot tables");
            ModClassLoader modClassLoader = Loader.instance().getModClassLoader();
            HashSet<Path> visitedSources = new HashSet<Path>();
            for (ModContainer mod : Loader.instance().getActiveModList()) {
                if (mod.getSource() == null) {
                    LOGGER.info("Skipped {} ({}) as it reported a null source", (Object)mod.getModId(), (Object)mod.getName());
                    continue;
                }
                if (!mod.getSource().exists()) {
                    Level level = mod.getModId().equals("minecraft") || mod.getModId().equals("mcp") ? Level.DEBUG : Level.INFO;
                    LOGGER.log(level, "Skipped {} ({}) as it reported a nonexistent source {}", (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getSource().getAbsolutePath());
                    continue;
                }
                Path sourcePath = mod.getSource().toPath();
                if (visitedSources.contains(sourcePath)) continue;
                LOGGER.debug("Visiting source of {} at {}", (Object)mod.getModId(), (Object)mod.getSource());
                this.visitSource((ClassLoader)modClassLoader, sourcePath, this::add);
                visitedSources.add(sourcePath);
            }
            LOGGER.info("All existing loot tables located");
            this.fullScanPerformed = true;
        }
        return this.validIds;
    }

    private void visitSource(ClassLoader modClassLoader, Path sourcePath, Consumer<ResourceLocation> idSubmitter) {
        try {
            FileSystem fs;
            if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                fs = FileSystems.getDefault();
                Path assetsDir = fs.getPath("assets", new String[0]);
                if (!Files.exists(assetsDir, new LinkOption[0])) {
                    return;
                }
                this.walkAssetsDirectory(assetsDir, idSubmitter);
            }
            fs = this.getFileSystem(modClassLoader, sourcePath);
            Throwable throwable = null;
            try {
                Path assetsDir = fs.getPath("assets", new String[0]);
                if (!Files.exists(assetsDir, new LinkOption[0])) {
                    return;
                }
                this.walkAssetsDirectory(assetsDir, idSubmitter);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fs != null) {
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fs.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private FileSystem getFileSystem(ClassLoader modClassLoader, Path sourcePath) throws IOException {
        return !Files.isDirectory(sourcePath, new LinkOption[0]) ? FileSystems.newFileSystem(sourcePath, modClassLoader) : FileSystems.getDefault();
    }

    private void walkAssetsDirectory(Path assetsDir, Consumer<ResourceLocation> idSubmitter) throws IOException {
        for (Path domain : Files.walk(assetsDir, 1, new FileVisitOption[0]).filter((Predicate<Path>)Predicates.not(assetsDir::equals))::iterator) {
            Path lootTablesDir = domain.resolve("loot_tables");
            if (!Files.exists(lootTablesDir, new LinkOption[0])) continue;
            this.walkLootTablesDirectory(lootTablesDir, idSubmitter);
        }
    }

    private void walkLootTablesDirectory(Path lootTablesDir, Consumer<ResourceLocation> idSubmitter) throws IOException {
        for (Path lootTable : Files.walk(lootTablesDir, new FileVisitOption[0]).filter((Predicate<Path>)Predicates.not(lootTablesDir::equals))::iterator) {
            if (!FilenameUtils.getExtension((String)lootTable.getFileName().toString()).equals("json")) continue;
            String namespace = lootTablesDir.getName(1).toString();
            String path = FilenameUtils.removeExtension((String)lootTablesDir.relativize(lootTable).toString());
            idSubmitter.accept(new ResourceLocation(namespace, path));
        }
    }
}

