/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.OpenBlocks;
import openblocks.client.Icons;
import openmods.Log;

public class SoundIconRegistry {
    private static final ResourceLocation ICON_FRAME = SoundIconRegistry.ob("frame");
    private final Icons.IDrawableIcon genericIcon = SoundIconRegistry.simpleIcon("generic", 0xFFFFFF);
    private final Icons.IDrawableIcon unknownIcon = SoundIconRegistry.simpleIcon("unknown", 0xFFFFFF);
    private final MappedCategory defaultRoot = new MappedCategory();
    private final Map<String, MappedCategory> roots = Maps.newHashMap();
    private Map<ResourceLocation, Icons.IDrawableIcon> iconCache = Maps.newConcurrentMap();
    public static final int DEFAULT_COLOR = 0xFFFFFF;

    private static ResourceLocation ob(String id) {
        return OpenBlocks.location("items/sound_" + id);
    }

    private static ResourceLocation mc(String id) {
        return new ResourceLocation("minecraft", id);
    }

    private static Icons.IDrawableIcon createMobIcon(ResourceLocation front, int primaryColor, int secondaryColor) {
        Icons.IDrawableIcon frame = Icons.createIcon(ICON_FRAME, secondaryColor);
        return SoundIconRegistry.makeFramedIcon(front, primaryColor, frame);
    }

    private static void addMob(MappedCategory category, String soundId, ResourceLocation mobId, boolean isHostile) {
        EntityList.EntityEggInfo mobInfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(mobId);
        if (mobInfo != null) {
            SoundIconRegistry.addMob(category, soundId, isHostile, mobInfo.field_75611_b, mobInfo.field_75612_c);
        } else {
            SoundIconRegistry.addMob(category, soundId, isHostile, -1, 0);
        }
    }

    private static void addMob(MappedCategory category, String soundId, boolean isHostile, int primaryColor, int secondaryColor) {
        MappedCategory cat = category.add(soundId, new MappedCategory());
        Icons.IDrawableIcon defaultIcon = SoundIconRegistry.createMobIcon(isHostile ? SoundIconRegistry.ob("mob_hostile") : SoundIconRegistry.ob("mob_friendly"), primaryColor, secondaryColor);
        cat.add("ambient", defaultIcon);
        cat.add("step", defaultIcon);
        cat.add("death", SoundIconRegistry.createMobIcon(SoundIconRegistry.ob("mob_death"), primaryColor, secondaryColor));
        cat.add("hurt", SoundIconRegistry.createMobIcon(SoundIconRegistry.ob("mob_hurt"), primaryColor, secondaryColor));
        cat.defaultIcon = defaultIcon;
    }

    @SubscribeEvent
    public void registerIcons(TextureStitchEvent evt) {
        TextureMap map = evt.getMap();
        this.genericIcon.registerIcons(map);
        this.unknownIcon.registerIcons(map);
        this.defaultRoot.registerIcons(map);
        for (MappedCategory category : this.roots.values()) {
            category.registerIcons(map);
        }
    }

    private Icons.IDrawableIcon findIcon(ResourceLocation sound) {
        try {
            Icons.IDrawableIcon result;
            MappedCategory domainRoot = this.roots.get(sound.func_110624_b());
            Iterable path = Splitter.on((char)'.').split((CharSequence)sound.func_110623_a());
            if (domainRoot != null && (result = domainRoot.getIcon(path.iterator())) != null) {
                return result;
            }
            result = this.defaultRoot.getIcon(path.iterator());
            return result != null ? result : this.genericIcon;
        }
        catch (NoSuchElementException e) {
            Log.warn((String)"Malformed sound name: %s", (Object[])new Object[]{sound});
            return this.defaultRoot.defaultIcon;
        }
    }

    public Icons.IDrawableIcon getIcon(ResourceLocation sound) {
        Icons.IDrawableIcon result = this.iconCache.get(sound);
        if (result == null) {
            result = this.findIcon(sound);
            this.iconCache.put(sound, result);
        }
        return result;
    }

    private static Icons.IDrawableIcon simpleIcon(String id, int color) {
        return Icons.createIcon(SoundIconRegistry.ob(id), color);
    }

    private static Icons.IDrawableIcon makeLayeredIcon(Icons.IDrawableIcon front, Icons.IDrawableIcon back) {
        return new Icons.ComposedIcon(front, back, 1.0, 1.0E-5);
    }

    public static Icons.IDrawableIcon makeFramedIcon(Icons.IDrawableIcon front, Icons.IDrawableIcon back, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon inner = SoundIconRegistry.makeLayeredIcon(front, back);
        return new Icons.ComposedIcon(frame, inner, 0.6, 0.0);
    }

    public static Icons.IDrawableIcon makeFramedIcon(Icons.IDrawableIcon inner, Icons.IDrawableIcon frame) {
        return new Icons.ComposedIcon(frame, inner, 0.6, 0.0);
    }

    private static Icons.IDrawableIcon makeFramedIcon(ResourceLocation innerIcon, int innerColor, Icons.IDrawableIcon frame) {
        Icons.IDrawableIcon inner = Icons.createIcon(innerIcon, innerColor);
        return SoundIconRegistry.makeFramedIcon(inner, frame);
    }

    private static Icons.IDrawableIcon makeFramedIcon(ResourceLocation innerIcon, Icons.IDrawableIcon frame) {
        return SoundIconRegistry.makeFramedIcon(innerIcon, 0xFFFFFF, frame);
    }

    private static void addForStandardBlock(MappedCategory cat, String name, ResourceLocation block) {
        Icons.IDrawableIcon blockIcon = Icons.createIcon(block);
        Icons.IDrawableIcon dig = Icons.createIcon(SoundIconRegistry.mc("items/diamond_shovel"));
        Icons.IDrawableIcon step = Icons.createIcon(SoundIconRegistry.mc("items/diamond_boots"));
        Icons.IDrawableIcon hurt = Icons.createIcon(SoundIconRegistry.ob("mob_hurt"));
        Icons.IDrawableIcon br = Icons.createIcon(SoundIconRegistry.mc("blocks/destroy_stage_5"));
        Icons.IDrawableIcon unknown = Icons.createIcon(SoundIconRegistry.ob("unknown"));
        Icons.IDrawableIcon whiteFrame = Icons.createIcon(ICON_FRAME, 0xFFFFFF);
        MappedCategory blockCategory = cat.add(name, new MappedCategory());
        blockCategory.add("break", SoundIconRegistry.makeFramedIcon(br, blockIcon, whiteFrame));
        blockCategory.add("fall", SoundIconRegistry.makeFramedIcon(hurt, blockIcon, whiteFrame));
        blockCategory.add("hit", SoundIconRegistry.makeFramedIcon(dig, blockIcon, whiteFrame));
        blockCategory.add("place", SoundIconRegistry.makeFramedIcon(blockIcon, whiteFrame));
        blockCategory.add("step", SoundIconRegistry.makeFramedIcon(step, blockIcon, whiteFrame));
        blockCategory.defaultIcon = SoundIconRegistry.makeLayeredIcon(unknown, blockIcon);
    }

    public static MappedCategory createSingleIconCategory(ResourceLocation icon, boolean frame) {
        MappedCategory result = new MappedCategory();
        result.defaultIcon = frame ? SoundIconRegistry.makeFramedIcon(icon, Icons.createIcon(ICON_FRAME, 0xFFFFFF)) : Icons.createIcon(icon, -1);
        return result;
    }

    private static void addForBasicBlock(MappedCategory cat, String name, ResourceLocation block) {
        Icons.IDrawableIcon blockIcon = Icons.createIcon(block);
        Icons.IDrawableIcon whiteFrame = Icons.createIcon(ICON_FRAME, 0xFFFFFF);
        MappedCategory blockCategory = cat.add(name, new MappedCategory());
        blockCategory.defaultIcon = SoundIconRegistry.makeFramedIcon(blockIcon, whiteFrame);
    }

    private static void addForBasicBlockAction(MappedCategory cat, String name, ResourceLocation block) {
        Icons.IDrawableIcon blockIcon = Icons.createIcon(block);
        Icons.IDrawableIcon action = Icons.createIcon(SoundIconRegistry.ob("click"), 0xFFFFFF);
        MappedCategory blockCategory = cat.add(name, new MappedCategory());
        blockCategory.defaultIcon = SoundIconRegistry.makeLayeredIcon(action, blockIcon);
    }

    private MappedCategory createRoot(String id) {
        MappedCategory root = new MappedCategory();
        this.roots.put(id, root);
        return root;
    }

    public void registerDefaults() {
        Icons.IDrawableIcon whiteFrame;
        Icons.IDrawableIcon frame;
        Icons.IDrawableIcon frameWhite = frame = (whiteFrame = Icons.createIcon(ICON_FRAME, 0xFFFFFF));
        Icons.IDrawableIcon frameRed = Icons.createIcon(ICON_FRAME, 0xFF0000);
        Icons.IDrawableIcon frameBlue = Icons.createIcon(ICON_FRAME, 255);
        this.defaultRoot.defaultIcon = this.unknownIcon;
        MappedCategory mcRoot = this.createRoot("minecraft");
        mcRoot.defaultIcon = this.unknownIcon;
        MappedCategory blocks = mcRoot.add("block", new MappedCategory());
        SoundIconRegistry.addForStandardBlock(blocks, "anvil", SoundIconRegistry.mc("blocks/anvil_base"));
        SoundIconRegistry.addForStandardBlock(blocks, "cloth", SoundIconRegistry.mc("blocks/wool_colored_white"));
        SoundIconRegistry.addForStandardBlock(blocks, "glass", SoundIconRegistry.mc("blocks/glass"));
        SoundIconRegistry.addForStandardBlock(blocks, "grass", SoundIconRegistry.mc("blocks/dirt"));
        SoundIconRegistry.addForStandardBlock(blocks, "gravel", SoundIconRegistry.mc("blocks/gravel"));
        SoundIconRegistry.addForStandardBlock(blocks, "ladder", SoundIconRegistry.mc("blocks/ladder"));
        SoundIconRegistry.addForStandardBlock(blocks, "metal", SoundIconRegistry.mc("blocks/iron_block"));
        SoundIconRegistry.addForStandardBlock(blocks, "sand", SoundIconRegistry.mc("blocks/sand"));
        SoundIconRegistry.addForStandardBlock(blocks, "slime", SoundIconRegistry.mc("blocks/slime"));
        SoundIconRegistry.addForStandardBlock(blocks, "snow", SoundIconRegistry.mc("blocks/snow"));
        SoundIconRegistry.addForStandardBlock(blocks, "stone", SoundIconRegistry.mc("blocks/stone"));
        SoundIconRegistry.addForStandardBlock(blocks, "wood", SoundIconRegistry.mc("blocks/log_oak_top"));
        SoundIconRegistry.addForBasicBlock(blocks, "brewing_stand", SoundIconRegistry.mc("blocks/brewing_stand"));
        SoundIconRegistry.addForBasicBlock(blocks, "chest", SoundIconRegistry.mc("blocks/planks_oak"));
        SoundIconRegistry.addForBasicBlock(blocks, "chorus_flower", SoundIconRegistry.mc("blocks/chorus_flower"));
        SoundIconRegistry.addForBasicBlock(blocks, "comparator", SoundIconRegistry.mc("blocks/comparator_on"));
        SoundIconRegistry.addForBasicBlock(blocks, "dispenser", SoundIconRegistry.mc("blocks/dispenser_front_horizontal"));
        SoundIconRegistry.addForBasicBlock(blocks, "enchantment_table", SoundIconRegistry.mc("blocks/enchanting_table_top"));
        SoundIconRegistry.addForBasicBlock(blocks, "end_gateway", SoundIconRegistry.mc("items/end_crystal"));
        SoundIconRegistry.addForBasicBlock(blocks, "enderchest", SoundIconRegistry.mc("items/ender_eye"));
        SoundIconRegistry.addForBasicBlock(blocks, "fence_gate", SoundIconRegistry.mc("blocks/planks_oak"));
        SoundIconRegistry.addForBasicBlock(blocks, "fire", SoundIconRegistry.mc("blocks/fire_layer_0"));
        SoundIconRegistry.addForBasicBlock(blocks, "furnace", SoundIconRegistry.mc("blocks/furnace_front_on"));
        SoundIconRegistry.addForBasicBlock(blocks, "iron_door", SoundIconRegistry.mc("items/door_iron"));
        SoundIconRegistry.addForBasicBlock(blocks, "iron_trapdoor", SoundIconRegistry.mc("blocks/iron_trapdoor"));
        SoundIconRegistry.addForBasicBlock(blocks, "lava", SoundIconRegistry.mc("blocks/lava_flow"));
        SoundIconRegistry.addForBasicBlock(blocks, "piston", SoundIconRegistry.mc("blocks/piston_side"));
        SoundIconRegistry.addForBasicBlock(blocks, "portal", SoundIconRegistry.mc("blocks/portal"));
        SoundIconRegistry.addForBasicBlock(blocks, "redstone_torch", SoundIconRegistry.mc("blocks/redstone_torch_on"));
        SoundIconRegistry.addForBasicBlock(blocks, "tripwire", SoundIconRegistry.mc("blocks/trip_wire_source"));
        SoundIconRegistry.addForBasicBlock(blocks, "water", SoundIconRegistry.mc("blocks/water_flow"));
        SoundIconRegistry.addForBasicBlock(blocks, "waterlily", SoundIconRegistry.mc("blocks/waterlily"));
        SoundIconRegistry.addForBasicBlock(blocks, "wooden_door", SoundIconRegistry.mc("items/door_wood"));
        SoundIconRegistry.addForBasicBlock(blocks, "wooden_trapdoor", SoundIconRegistry.mc("blocks/trapdoor"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "metal_pressureplate", SoundIconRegistry.mc("blocks/iron_block"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "stone_button", SoundIconRegistry.mc("blocks/stone"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "stone_pressureplate", SoundIconRegistry.mc("blocks/stone"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "wood_button", SoundIconRegistry.mc("blocks/planks_oak"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "wood_pressureplate", SoundIconRegistry.mc("blocks/planks_oak"));
        SoundIconRegistry.addForBasicBlockAction(blocks, "lever", SoundIconRegistry.mc("blocks/lever"));
        TintedIconCategory note = blocks.add("note", new TintedIconCategory(SoundIconRegistry.ob("note")));
        note.add("basedrum", 65535);
        note.add("bass", 255);
        note.add("harp", 0xFFFF00);
        note.add("harp", 0xFF0000);
        note.add("hat", 65280);
        note.add("pling", 0xFF00FF);
        note.add("snare", 0xFFFFFF);
        MappedCategory entity = mcRoot.add("entity", new MappedCategory());
        SoundIconRegistry.addMob(entity, "blaze", SoundIconRegistry.mc("blaze"), true);
        SoundIconRegistry.addMob(entity, "creeper", SoundIconRegistry.mc("Creeper"), true);
        SoundIconRegistry.addMob(entity, "elder_guardian", SoundIconRegistry.mc("elder_guardian"), true);
        SoundIconRegistry.addMob(entity, "enderdragon", SoundIconRegistry.mc("ender_dragon"), true);
        SoundIconRegistry.addMob(entity, "endermen", SoundIconRegistry.mc("enderman"), true);
        SoundIconRegistry.addMob(entity, "endermite", SoundIconRegistry.mc("endermite"), true);
        SoundIconRegistry.addMob(entity, "ghast", SoundIconRegistry.mc("ghast"), true);
        SoundIconRegistry.addMob(entity, "guardian", SoundIconRegistry.mc("guardian"), true);
        SoundIconRegistry.addMob(entity, "husk", SoundIconRegistry.mc("husk"), true);
        SoundIconRegistry.addMob(entity, "evocation_illager", SoundIconRegistry.mc("evocation_illager"), true);
        SoundIconRegistry.addMob(entity, "magmacube", SoundIconRegistry.mc("magma_cube"), true);
        SoundIconRegistry.addMob(entity, "shulker", SoundIconRegistry.mc("shulker"), true);
        SoundIconRegistry.addMob(entity, "silverfish", SoundIconRegistry.mc("silverfish"), true);
        SoundIconRegistry.addMob(entity, "skeleton", SoundIconRegistry.mc("skeleton"), true);
        SoundIconRegistry.addMob(entity, "slime", SoundIconRegistry.mc("slime"), true);
        SoundIconRegistry.addMob(entity, "small_magmacube", SoundIconRegistry.mc("magma_cube"), true);
        SoundIconRegistry.addMob(entity, "small_slime", SoundIconRegistry.mc("slime"), true);
        SoundIconRegistry.addMob(entity, "spider", SoundIconRegistry.mc("spider"), true);
        SoundIconRegistry.addMob(entity, "stray", SoundIconRegistry.mc("stray"), true);
        SoundIconRegistry.addMob(entity, "vex", SoundIconRegistry.mc("vex"), true);
        SoundIconRegistry.addMob(entity, "vindication_illager", SoundIconRegistry.mc("vindication_illager"), true);
        SoundIconRegistry.addMob(entity, "witch", SoundIconRegistry.mc("witch"), true);
        SoundIconRegistry.addMob(entity, "wither", SoundIconRegistry.mc("wither"), true);
        SoundIconRegistry.addMob(entity, "wither_skeleton", SoundIconRegistry.mc("wither_skeleton"), true);
        SoundIconRegistry.addMob(entity, "zombie", SoundIconRegistry.mc("zombie"), true);
        SoundIconRegistry.addMob(entity, "zombie_villager", SoundIconRegistry.mc("zombie_villager"), true);
        SoundIconRegistry.addMob(entity, "bat", SoundIconRegistry.mc("bat"), false);
        SoundIconRegistry.addMob(entity, "cat", SoundIconRegistry.mc("ocelot"), false);
        SoundIconRegistry.addMob(entity, "chicken", SoundIconRegistry.mc("chicken"), false);
        SoundIconRegistry.addMob(entity, "cow", SoundIconRegistry.mc("cow"), false);
        SoundIconRegistry.addMob(entity, "donkey", SoundIconRegistry.mc("donkey"), false);
        SoundIconRegistry.addMob(entity, "horse", SoundIconRegistry.mc("horse"), false);
        SoundIconRegistry.addMob(entity, "irongolem", SoundIconRegistry.mc("villager_golem"), false);
        SoundIconRegistry.addMob(entity, "llama", SoundIconRegistry.mc("llama"), false);
        SoundIconRegistry.addMob(entity, "mooshroom", SoundIconRegistry.mc("mooshroom"), false);
        SoundIconRegistry.addMob(entity, "mule", SoundIconRegistry.mc("mule"), false);
        SoundIconRegistry.addMob(entity, "pig", SoundIconRegistry.mc("pig"), false);
        SoundIconRegistry.addMob(entity, "polar_bear", SoundIconRegistry.mc("polar_bear"), false);
        SoundIconRegistry.addMob(entity, "rabbit", SoundIconRegistry.mc("rabbit"), false);
        SoundIconRegistry.addMob(entity, "sheep", SoundIconRegistry.mc("sheep"), false);
        SoundIconRegistry.addMob(entity, "skeleton_horse", SoundIconRegistry.mc("skeleton_horse"), false);
        SoundIconRegistry.addMob(entity, "snowman", SoundIconRegistry.mc("snowman"), false);
        SoundIconRegistry.addMob(entity, "squid", SoundIconRegistry.mc("squid"), false);
        SoundIconRegistry.addMob(entity, "villager", SoundIconRegistry.mc("villager"), false);
        SoundIconRegistry.addMob(entity, "wolf", SoundIconRegistry.mc("wolf"), false);
        SoundIconRegistry.addMob(entity, "zombie_horse", SoundIconRegistry.mc("zombie_horse"), false);
        SoundIconRegistry.addMob(entity, "zombie_pig", SoundIconRegistry.mc("zombie_pigman"), false);
        MappedCategory player = entity.add("player", new MappedCategory());
        player.add("burp", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/potato_baked"), frameWhite));
        player.add("levelup", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/experience_bottle"), frameWhite));
        Icons.IDrawableIcon playerBack = Icons.createIcon(SoundIconRegistry.ob("player"));
        player.defaultIcon = SoundIconRegistry.makeFramedIcon(playerBack, frameWhite);
        player.add("die", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.makeFramedIcon(SoundIconRegistry.ob("mob_death"), 0xFFFFFF, frameWhite), playerBack, frameRed));
        player.add("hurt", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.makeFramedIcon(SoundIconRegistry.ob("mob_hurt"), 0xFFFFFF, frameWhite), playerBack, frameRed));
        entity.add("experience_orb", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/experience_bottle"), true));
        entity.add("arrow", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/arrow"), true));
        entity.add("egg", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/experience_bottle"), true));
        entity.add("endereye", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/ender_eye"), true));
        entity.add("enderpearl", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/ender_pearl"), true));
        entity.add("experience_bottle", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/experience_bottle"), true));
        entity.add("firework", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/fireworks"), true));
        entity.add("item", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.ob("click"), false));
        entity.add("itemframe", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/item_frame"), true));
        entity.add("leashknot", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/lead"), true));
        entity.add("lightning", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.ob("click"), false));
        entity.add("lingeringpotion", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/potion_bottle_lingering"), true));
        entity.add("minecart", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/minecart_normal"), true));
        entity.add("painting", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/painting"), true));
        entity.add("snowball", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/snowball"), true));
        entity.add("splash_potion", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/potion_bottle_splash"), true));
        entity.add("tnt", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("blocks/tnt_side"), true));
        entity.add("armorstand", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/wooden_armorstand"), true));
        entity.add("bobber", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/fishing_rod_cast"), true));
        entity.add("evocation_fangs", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/fishing_rod_cast"), true));
        MappedCategory generic = entity.add("generic", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.ob("generic"), false));
        generic.add("burn", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("blocks/fire_layer_0"), whiteFrame));
        generic.add("death", SoundIconRegistry.simpleIcon("mob_death", -1));
        generic.add("drink", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/potion_bottle_drinkable"), whiteFrame));
        generic.add("eat", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/potato_baked"), whiteFrame));
        generic.add("extinguish_fire", SoundIconRegistry.simpleIcon("fizz", -1));
        generic.add("hurt", SoundIconRegistry.simpleIcon("mob_hurt", -1));
        generic.add("small_fall", SoundIconRegistry.simpleIcon("mob_hurt", -1));
        generic.add("splash", SoundIconRegistry.simpleIcon("rain", -1));
        generic.add("swim", SoundIconRegistry.simpleIcon("fizz", -1));
        MappedCategory item = mcRoot.add("item", new MappedCategory());
        MappedCategory armor = item.add("armor", new MappedCategory());
        armor.add("equip_chain", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/chainmail_chestplate"), whiteFrame));
        armor.add("equip_diamond", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/diamond_chestplate"), whiteFrame));
        armor.add("equip_gold", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/gold_chestplate"), whiteFrame));
        armor.add("equip_iron", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/iron_chestplate"), whiteFrame));
        armor.add("equip_leather", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/leather_chestplate"), whiteFrame));
        armor.add("equip_generic", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/empty_armor_slot_chestplate"), whiteFrame));
        item.add("bottle", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/potion_bottle_empty"), true));
        item.add("bucket", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/bucket_empty"), true));
        item.add("chorus_fruit", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/chorus_fruit_popped"), true));
        item.add("elytra", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/elytra"), true));
        item.add("firecharge", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/fireball"), true));
        item.add("flintandsteel", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/flint_and_steel"), true));
        item.add("hoe", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/wood_hoe"), true));
        item.add("shield", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/empty_armor_slot_shield"), true));
        item.add("shovel", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.mc("items/wood_shovel"), true));
        MappedCategory records = mcRoot.add("record", new MappedCategory());
        records.add("13", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_13"), frameBlue));
        records.add("cat", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_cat"), frameBlue));
        records.add("blocks", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_blocks"), frameBlue));
        records.add("chirp", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_chirp"), frameBlue));
        records.add("far", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_far"), frameBlue));
        records.add("mall", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_mall"), frameBlue));
        records.add("mellohi", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_mellohi"), frameBlue));
        records.add("stal", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_stal"), frameBlue));
        records.add("strad", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_strad"), frameBlue));
        records.add("ward", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_ward"), frameBlue));
        records.add("11", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_11"), frameBlue));
        records.add("wait", SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/record_wait"), frameBlue));
        MappedCategory weather = mcRoot.add("weather", new MappedCategory());
        weather.add("rain", SoundIconRegistry.simpleIcon("rain", 255));
        mcRoot.add("ui", SoundIconRegistry.createSingleIconCategory(SoundIconRegistry.ob("click"), false));
        Icons.IDrawableIcon potato = SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/potato_baked"), frameWhite);
        Icons.IDrawableIcon apple = SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/apple"), frameWhite);
        Icons.IDrawableIcon pearl = SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/ender_pearl"), frameWhite);
        Icons.IDrawableIcon write = SoundIconRegistry.makeFramedIcon(SoundIconRegistry.mc("items/book_writable"), frameWhite);
        MappedCategory openblocks = this.createRoot("openblocks");
        openblocks.defaultIcon = this.genericIcon;
        MappedCategory elevator = openblocks.add("elevator", new MappedCategory());
        elevator.defaultIcon = pearl;
        MappedCategory luggage = openblocks.add("luggage", new MappedCategory());
        luggage.defaultIcon = this.genericIcon;
        MappedCategory eat = luggage.add("eat", new MappedCategory());
        eat.add("item", apple);
        eat.add("food", potato);
        MappedCategory crayon = openblocks.add("crayon", new MappedCategory());
        crayon.add("place", write);
    }

    public static class SkipPath
    implements ISoundCategory {
        private final ISoundCategory child;

        private SkipPath(ISoundCategory child) {
            Preconditions.checkNotNull((Object)child);
            this.child = child;
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            path.next();
            return this.child.getIcon(path);
        }

        @Override
        public void registerIcons(TextureMap registry) {
            this.child.registerIcons(registry);
        }
    }

    private static class TintedIconCategory
    extends MappedCategory {
        private final ResourceLocation iconId;

        private TintedIconCategory(ResourceLocation iconId) {
            this.iconId = iconId;
        }

        public void add(String id, int color) {
            Icons.IDrawableIcon icon = Icons.createIcon(this.iconId, color);
            this.add(id, new ConstantIcon(icon));
        }
    }

    private static class MappedCategory
    implements ISoundCategory {
        public Icons.IDrawableIcon defaultIcon;
        private final Map<String, ISoundCategory> subCategories = Maps.newHashMap();

        private MappedCategory() {
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            String id = path.next();
            ISoundCategory result = this.subCategories.get(id);
            if (result == null) {
                return this.defaultIcon;
            }
            Icons.IDrawableIcon icon = result.getIcon(path);
            return icon != null ? icon : this.defaultIcon;
        }

        public <T extends ISoundCategory> T add(String id, T subcategory) {
            this.subCategories.put(id, subcategory);
            return subcategory;
        }

        public void add(String id, Icons.IDrawableIcon icon) {
            this.subCategories.put(id, new ConstantIcon(icon));
        }

        @Override
        public void registerIcons(TextureMap registry) {
            if (this.defaultIcon != null) {
                this.defaultIcon.registerIcons(registry);
            }
            for (ISoundCategory cat : this.subCategories.values()) {
                cat.registerIcons(registry);
            }
        }
    }

    public static class ConstantIcon
    implements ISoundCategory {
        private final Icons.IDrawableIcon icon;

        private ConstantIcon(Icons.IDrawableIcon icon) {
            this.icon = icon;
        }

        @Override
        public void registerIcons(TextureMap registry) {
            this.icon.registerIcons(registry);
        }

        @Override
        public Icons.IDrawableIcon getIcon(Iterator<String> path) {
            return this.icon;
        }
    }

    public static interface ISoundCategory {
        public Icons.IDrawableIcon getIcon(Iterator<String> var1);

        public void registerIcons(TextureMap var1);
    }
}

