/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.util;

import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.util.math.Vec3d;

public class ModRandom {
    private static final Random rand = new Random();

    public static float getFloat(float range) {
        return rand.nextFloat() * (float)ModRandom.randSign() * range;
    }

    public static int range(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("minimum is greater than maximum");
        }
        return min + rand.nextInt(max - min);
    }

    public static Vec3d randVec() {
        return new Vec3d((double)ModRandom.getFloat(0.5f), (double)ModRandom.getFloat(0.5f), (double)ModRandom.getFloat(0.5f));
    }

    public static Vec3d randFlatVec(Vec3d plane) {
        return ModRandom.randVec().func_72431_c(plane).func_72432_b();
    }

    public static Vec3d gaussVec() {
        return new Vec3d(rand.nextGaussian(), rand.nextGaussian(), rand.nextGaussian());
    }

    public static int randSign() {
        return rand.nextInt(2) == 0 ? 1 : -1;
    }

    public static <T> T choice(T[] array) {
        Random rand = new Random();
        return ModRandom.choice(array, rand);
    }

    public static <T> T choice(T[] array, Random rand) {
        int i = rand.nextInt(array.length);
        return array[i];
    }

    public static <T> RandomCollection<T> choice(List<T> items, Random rand, double[] weights) {
        return ModRandom.choice(items.toArray(), rand, weights);
    }

    public static <T> RandomCollection<T> choice(T[] array, Random rand, double[] weights) {
        if (array.length != weights.length) {
            throw new IllegalArgumentException("Lengths of items and weights arrays inequal");
        }
        RandomCollection<T> weightedRandom = new RandomCollection<T>(rand);
        for (int i = 0; i < array.length; ++i) {
            weightedRandom.add(weights[i], array[i]);
        }
        return weightedRandom;
    }

    public static <T> RandomCollection<T> choice(T[] array, Random rand, int[] weights) {
        double[] converted = new double[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            converted[i] = weights[i];
        }
        return ModRandom.choice(array, rand, converted);
    }

    public static class RandomCollection<E> {
        private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
        private final Random random;
        private double total = 0.0;

        public RandomCollection() {
            this(new Random());
        }

        public RandomCollection(Random random) {
            this.random = random;
        }

        public RandomCollection<E> add(double weight, E result) {
            if (weight <= 0.0) {
                return this;
            }
            if (Double.isNaN(weight) || Double.isInfinite(weight)) {
                throw new IllegalArgumentException("The weight for random collection is invalid: " + weight);
            }
            this.total += weight;
            this.map.put(this.total, result);
            return this;
        }

        public E next() {
            double value = this.random.nextDouble() * this.total;
            return this.map.higherEntry(value).getValue();
        }
    }
}

