/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.util;

import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.EntityElementalDamageSource;
import com.barribob.MaelstromMod.util.EntityElementalDamageSourceIndirect;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;

public class ModDamageSource {
    public static final String MAELSTROM = "mm:maelstrom";
    public static final String MOB = "mm:mobMaelstrom";
    public static final String PLAYER = "mm:playerMaelstrom";
    public static final String PROJECTILE = "mm:thrownMaelstrom";
    public static final String EXPLOSION = "mm:explosionMaelstrom.player";
    public static final String MAGIC = "mm:magicMaelstrom";
    public static final DamageSource MAELSTROM_DAMAGE = new DamageSource("mm:maelstrom");

    public static DamageSource causeElementalMeleeDamage(EntityLivingBase mob, Element element) {
        return new EntityElementalDamageSource(MOB, (Entity)mob, element);
    }

    public static DamageSource causeElementalPlayerDamage(EntityPlayer player, Element element) {
        return new EntityElementalDamageSource(PLAYER, (Entity)player, element);
    }

    public static DamageSource causeElementalThrownDamage(Entity source, @Nullable Entity indirectEntityIn, Element element) {
        return new EntityElementalDamageSourceIndirect(PROJECTILE, source, indirectEntityIn, element).func_76349_b();
    }

    public static DamageSource causeElementalMagicDamage(Entity source, @Nullable Entity indirectEntityIn, Element element) {
        return new EntityElementalDamageSourceIndirect(MAGIC, source, indirectEntityIn, element).func_76348_h();
    }

    public static DamageSource causeElementalExplosionDamage(@Nullable EntityLivingBase entityLivingBaseIn, Element element) {
        return new EntityElementalDamageSource(EXPLOSION, (Entity)entityLivingBaseIn, element).func_94540_d();
    }

    public static DamageSourceBuilder builder() {
        return new DamageSourceBuilder();
    }

    public static class DamageSourceBuilder {
        private Element element = Element.NONE;
        private Entity directEntity;
        private Entity indirectEntity;
        private String damageType = "mm:mobMaelstrom";
        private boolean stoppedByArmorNotShields;
        private boolean disablesShields;

        public DamageSourceBuilder element(Element element) {
            this.element = element;
            return this;
        }

        public DamageSourceBuilder directEntity(Entity directEntity) {
            this.directEntity = directEntity;
            return this;
        }

        public DamageSourceBuilder stoppedByArmorNotShields() {
            this.stoppedByArmorNotShields = true;
            return this;
        }

        public DamageSourceBuilder type(String damageType) {
            this.damageType = damageType;
            return this;
        }

        public DamageSourceBuilder indirectEntity(Entity indirectEntity) {
            this.indirectEntity = indirectEntity;
            return this;
        }

        public DamageSourceBuilder disablesShields() {
            this.disablesShields = true;
            return this;
        }

        public DamageSource build() {
            if (this.damageType == null || this.directEntity == null) {
                throw new NullPointerException("Damage source type or entity cannot be null");
            }
            EntityElementalDamageSourceIndirect source = new EntityElementalDamageSourceIndirect(this.damageType, this.directEntity, this.indirectEntity, this.element);
            if (this.stoppedByArmorNotShields) {
                source.setStoppedByArmor(true);
                source.field_76374_o = true;
            }
            source.setDisablesShields(this.disablesShields);
            return source;
        }
    }
}

