/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.gui;

import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.util.handlers.ArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InGameGui {
    public static final ResourceLocation ICONS = new ResourceLocation("mm:textures/gui/armor_icons.png");
    private static int manaFlashCounter;
    public static final int MAX_FLASH_COUNTER = 7;

    public static void setManaFlashCounter(int manaFlashCounter) {
        InGameGui.manaFlashCounter = manaFlashCounter;
    }

    private static void renderReload(int xPosition, int yPosition, double ammo) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (ammo != 0.0) {
            int i = Math.round(13.0f - (float)ammo * 13.0f);
            InGameGui.draw(bufferbuilder, xPosition + 2, yPosition + 13 - 2, 13, 2, 0, 0, 0, 255);
            InGameGui.draw(bufferbuilder, xPosition + 2, yPosition + 13 - 2, i, 1, 177, 220, 255, 255);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderArmorBar(Minecraft mc, RenderGameOverlayEvent.Post event, EntityPlayer player) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && mc.field_71442_b.func_78755_b()) {
            mc.func_110434_K().func_110577_a(ICONS);
            int startX = event.getResolution().func_78326_a() / 2 - 91;
            int startY = event.getResolution().func_78328_b() - GuiIngameForge.left_height;
            startX += ModConfig.gui.maelstrom_armor_bar_offset_x;
            startY += ModConfig.gui.maelstrom_armor_bar_offset_y;
            int maelstromArmor = ArmorHandler.getMaelstromArmorBars((Entity)player);
            if (maelstromArmor > 0) {
                for (int i = 0; i < 10; ++i) {
                    int x = startX + i * 8;
                    int armorPos = i * 2 + 1;
                    int animationLength = 9;
                    int framesPerTick = 3;
                    int y = 9 * (Math.floorDiv(player.field_70173_aa, framesPerTick) % animationLength);
                    if (armorPos < maelstromArmor) {
                        mc.field_71456_v.func_73729_b(x, startY, 0, y, 9, 9);
                    }
                    if (armorPos == maelstromArmor) {
                        mc.field_71456_v.func_73729_b(x, startY, 9, y, 9, 9);
                    }
                    if (armorPos <= maelstromArmor) continue;
                    mc.field_71456_v.func_73729_b(x, startY, 18, 0, 9, 9);
                }
            }
            GuiIngameForge.left_height += 10;
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderManaBar(Minecraft mc, RenderGameOverlayEvent.Post event, EntityPlayer player) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && mc.field_71442_b.func_78755_b()) {
            mc.func_110434_K().func_110577_a(ICONS);
            int width = event.getResolution().func_78326_a();
            int height = event.getResolution().func_78328_b();
            GlStateManager.func_179147_l();
            int top = height - GuiIngameForge.right_height;
            int fullBarX = 80;
            int left = width / 2 + 91 - fullBarX - 6;
            int framesPerTick = 4;
            int[] frames = new int[]{0, 1, 2, 3, 2, 1, 0};
            int frame = Math.floorDiv(player.field_70173_aa, framesPerTick) % frames.length;
            int animationY = 21 + frames[frame] * 5;
            mc.field_71456_v.func_73729_b(left += ModConfig.gui.maelstrom_mana_bar_offset_x, top += ModConfig.gui.maelstrom_mana_bar_offset_y, 31, 10, 96, 9);
            int[] whiteHighlightLocation = new int[]{36, 56};
            int[] redHighlightLocation = new int[]{36, 61};
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.5f * ((float)Math.abs(manaFlashCounter) / 7.0f)));
            if (manaFlashCounter > 0) {
                mc.field_71456_v.func_73729_b(left + 5, top + 2, whiteHighlightLocation[0], whiteHighlightLocation[1], fullBarX + 3, 5);
            } else if (manaFlashCounter < 0) {
                mc.field_71456_v.func_73729_b(left + 5, top + 2, redHighlightLocation[0], redHighlightLocation[1], fullBarX + 3, 5);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
            GuiIngameForge.right_height += 10;
        }
    }

    public static void updateCounter() {
        if (manaFlashCounter > 0) {
            --manaFlashCounter;
        } else if (manaFlashCounter < 0) {
            ++manaFlashCounter;
        }
    }
}

