/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.tileentity;

import com.barribob.MaelstromMod.entity.tileentity.MobSpawnerLogic;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MaelstromMobSpawnerLogic
extends MobSpawnerLogic {
    private int minSpawnDelay = 600;
    private int maxSpawnDelay = 800;

    public MaelstromMobSpawnerLogic(Supplier<World> world, Supplier<BlockPos> pos, Block block) {
        super(world, pos, block);
    }

    private boolean isActivated() {
        BlockPos blockpos = (BlockPos)this.pos.get();
        return ((World)this.world.get()).func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.activatingRangeFromPlayer);
    }

    @Override
    public void updateSpawner() {
        if (((World)this.world.get()).field_72995_K || !this.isActivated()) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.resetTimer();
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        while (this.count < this.maxCount) {
            int tries = 20;
            for (int t = 0; t < tries && !this.tryToSpawnEntity(); ++t) {
                if (t != tries - 1) continue;
                ++this.count;
            }
        }
        this.resetTimer();
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + ((World)this.world.get()).field_73012_v.nextInt(i);
        }
        this.count = 0;
        this.broadcastEvent(1);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
        }
        super.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.getEntityData() != null) {
            compound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
            compound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        }
        return super.writeToNBT(compound);
    }
}

