/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileGun;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileMonolithFireball
extends ProjectileGun {
    private static final int EXPOSION_AREA_FACTOR = 2;
    public static final Vec3d FIREBALL_COLOR = new Vec3d(1.0, 0.6, 0.5);

    public ProjectileMonolithFireball(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage, stack);
        this.func_189654_d(true);
    }

    public ProjectileMonolithFireball(World worldIn) {
        super(worldIn);
        this.func_189654_d(true);
    }

    public ProjectileMonolithFireball(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.func_189654_d(true);
    }

    @Override
    public void func_70071_h_() {
        this.func_184185_a(SoundEvents.field_187646_bt, 0.5f, ModRandom.getFloat(0.2f) + 1.0f);
        super.func_70071_h_();
    }

    @Override
    protected void spawnParticles() {
        float size = 0.25f;
        ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a((double)size)), ModColors.RED);
        this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        float groundHeight = (float)ModUtils.findGroundBelow(this.field_70170_p, this.func_180425_c()).func_177956_o() + 1.2f;
        Vec3d indicationPos = new Vec3d(this.field_70165_t, (double)groundHeight, this.field_70161_v);
        ModUtils.circleCallback(2.0f, 6, pos -> {
            Vec3d circleOffset = this.rotateCircleOverTime((Vec3d)pos);
            ParticleManager.spawnEffect(this.field_70170_p, indicationPos.func_178787_e(circleOffset), ModColors.RED);
        });
    }

    private Vec3d rotateCircleOverTime(Vec3d pos) {
        Vec3d circleOffset = new Vec3d(pos.field_72450_a, 0.0, pos.field_72448_b);
        circleOffset = ModUtils.rotateVector2(circleOffset, ModUtils.Y_AXIS, this.field_70173_aa * 2);
        return circleOffset;
    }

    @Override
    protected void spawnImpactParticles() {
        for (int i = 0; i < 30; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t + (double)ModRandom.getFloat(2.0f), this.field_70163_u + (double)ModRandom.getFloat(2.0f), this.field_70161_v + (double)ModRandom.getFloat(2.0f), 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (double)ModRandom.getFloat(2.0f), this.field_70163_u + (double)ModRandom.getFloat(2.0f), this.field_70161_v + (double)ModRandom.getFloat(2.0f), 0.0, 0.0, 0.0, new int[0]);
            ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(4.0)), ModColors.RED);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        float knockbackFactor = 1.1f + (float)this.getKnockback() * 0.4f;
        int fireFactor = this.func_70027_ad() ? 8 : 3;
        DamageSource source = ModDamageSource.builder().type("mm:explosionMaelstrom.player").directEntity(this).indirectEntity((Entity)this.shootingEntity).stoppedByArmorNotShields().element(this.getElement()).build();
        ModUtils.handleAreaImpact(2.0f, this::getGunDamage, (Entity)this.shootingEntity, this.func_174791_d(), source, knockbackFactor, fireFactor);
        if (!this.field_70170_p.field_72995_K) {
            for (int j = 0; j < 5; ++j) {
                Vec3d pos = this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(1.0));
                if (!this.field_70170_p.func_175665_u(new BlockPos(pos).func_177977_b()) || !this.field_70170_p.func_175623_d(new BlockPos(pos))) continue;
                this.field_70170_p.func_175656_a(new BlockPos(pos), Blocks.field_150480_ab.func_176223_P());
            }
        }
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        super.onHit(result);
    }
}

