/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities.gauntlet;

import com.barribob.MaelstromMod.entity.ai.AIAerialTimedAttack;
import com.barribob.MaelstromMod.entity.ai.AiFistWander;
import com.barribob.MaelstromMod.entity.ai.EntityAIWanderWithGroup;
import com.barribob.MaelstromMod.entity.ai.FlyingMoveHelper;
import com.barribob.MaelstromMod.entity.ai.GauntletEntitySenses;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.entities.gauntlet.DefendAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.GauntletAttackInitiator;
import com.barribob.MaelstromMod.entity.entities.gauntlet.IGauntletAction;
import com.barribob.MaelstromMod.entity.entities.gauntlet.MovementTracker;
import com.barribob.MaelstromMod.entity.entities.gauntlet.PunchAction;
import com.barribob.MaelstromMod.entity.util.DirectionalRender;
import com.barribob.MaelstromMod.entity.util.IPitch;
import com.barribob.MaelstromMod.renderer.ITarget;
import com.barribob.MaelstromMod.util.ModColors;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.RenderUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.entity.RenderDragon;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityAbstractMaelstromGauntlet
extends EntityMaelstromMob
implements IEntityMultiPart,
DirectionalRender,
ITarget,
IPitch {
    protected static final DataParameter<Float> LOOK = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187193_c);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_6);
    private final MultiPartEntityPart[] hitboxParts;
    private final float boxSize = 0.8f;
    private final MultiPartEntityPart eye = new MultiPartEntityPart((IEntityMultiPart)this, "eye", 1.2f, 1.2f);
    private final MultiPartEntityPart behindEye = new MultiPartEntityPart((IEntityMultiPart)this, "behindEye", 1.0f, 1.0f);
    private final MultiPartEntityPart bottomPalm = new MultiPartEntityPart((IEntityMultiPart)this, "bottomPalm", 1.2f, 1.2f);
    private final MultiPartEntityPart upLeftPalm = new MultiPartEntityPart((IEntityMultiPart)this, "upLeftPalm", 0.8f, 0.8f);
    private final MultiPartEntityPart upRightPalm = new MultiPartEntityPart((IEntityMultiPart)this, "upRightPalm", 0.8f, 0.8f);
    private final MultiPartEntityPart rightPalm = new MultiPartEntityPart((IEntityMultiPart)this, "rightPalm", 0.8f, 0.8f);
    private final MultiPartEntityPart leftPalm = new MultiPartEntityPart((IEntityMultiPart)this, "leftPalm", 0.8f, 0.8f);
    private final MultiPartEntityPart fingers = new MultiPartEntityPart((IEntityMultiPart)this, "fingers", 1.2f, 1.2f);
    protected final MultiPartEntityPart fist = new MultiPartEntityPart((IEntityMultiPart)this, "fist", 0.0f, 0.0f);
    private IGauntletAction currentAction;
    protected static final byte stopLazerByte = 39;
    private final double punchImpactSize = this.getMobConfig().getDouble("punch_impact_size");
    @Nullable
    private MovementTracker movement;
    IGauntletAction defendAction = new DefendAction(this);
    private Vec3d renderLazerPos;
    private Vec3d prevRenderLazerPos;
    private boolean damageFromEye;
    private final EntitySenses senses = new GauntletEntitySenses((EntityLiving)this);
    public final Consumer<Vec3d> punchAtPos = target -> {
        this.currentAction = new PunchAction("gauntlet.punch", () -> target, () -> {}, this, (Entity)this.fist);
        this.currentAction.doAction();
        for (int i = 0; i < 12; ++i) {
            this.addEvent(() -> ModUtils.faceDirection((EntityLiving)this, target, 15), i);
        }
    };

    public EntityAbstractMaelstromGauntlet(World worldIn) {
        super(worldIn);
        this.field_70765_h = new FlyingMoveHelper((EntityLiving)this);
        this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
        this.hitboxParts = new MultiPartEntityPart[]{this.eye, this.behindEye, this.bottomPalm, this.upLeftPalm, this.upRightPalm, this.rightPalm, this.leftPalm, this.fingers, this.fist};
        this.func_70105_a(2.0f, 4.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.healthScaledAttackFactor = 0.1;
        if (!this.field_70170_p.field_72995_K) {
            this.initGauntletAI();
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.26f);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        ModUtils.removeTaskOfType(this.field_70714_bg, EntityAIWanderWithGroup.class);
    }

    @Override
    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_186662_g(targetDistance);
    }

    private void initGauntletAI() {
        float attackDistance = (float)this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAerialTimedAttack((EntityLiving)this, attackDistance, 20.0f, 20.0f, new GauntletAttackInitiator(60, this::startAttack, this::defendAttack)));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AiFistWander((EntityLiving)this, this.punchAtPos, 120, 10.0f));
    }

    public final IGauntletAction startAttack(EntityLivingBase target) {
        float distanceSq = (float)this.func_70068_e((Entity)target);
        this.currentAction = this.getNextAttack(target, distanceSq, this.currentAction);
        this.currentAction.doAction();
        return this.currentAction;
    }

    protected abstract IGauntletAction getNextAttack(EntityLivingBase var1, float var2, IGauntletAction var3);

    @Nullable
    public final IGauntletAction defendAttack(EntityLivingBase target) {
        if (this.seesDanger(this.movement, target)) {
            this.currentAction = this.defendAction;
            this.defendAction.doAction();
            return this.defendAction;
        }
        return null;
    }

    public void func_70624_b(@Nullable EntityLivingBase entity) {
        if (entity != null && (this.movement == null || this.movement.entity != entity)) {
            this.movement = new MovementTracker((Entity)entity, 5);
        } else if (entity == null) {
            this.movement = null;
        }
        super.func_70624_b(entity);
    }

    public void func_70030_z() {
        if (this.movement != null) {
            this.movement.onUpdate();
        }
        super.func_70030_z();
    }

    private boolean seesDanger(@Nullable MovementTracker movementTracker, EntityLivingBase target) {
        if (movementTracker == null) {
            return false;
        }
        Vec3d targetMovement = movementTracker.getMovementOverTicks(5);
        double velocityTowardsThis = ModUtils.direction(target.func_174791_d(), this.func_174791_d()).func_72430_b(targetMovement);
        return velocityTowardsThis > 3.0;
    }

    @Override
    public final boolean func_70097_a(DamageSource source, float amount) {
        if (!this.damageFromEye && !source.func_76363_c()) {
            return false;
        }
        this.damageFromEye = false;
        return super.func_70097_a(source, amount);
    }

    public final boolean func_70965_a(@Nonnull MultiPartEntityPart part, @Nonnull DamageSource source, float damage) {
        if (!(part != this.eye || this.currentAction != null && this.currentAction.isImmuneToDamage())) {
            this.damageFromEye = true;
            if (damage > 0.0f && this.isImmovable()) {
                this.setImmovable(false);
            }
            return this.func_70097_a(source, damage);
        }
        if (damage > 0.0f && !source.func_76363_c()) {
            Entity entity;
            if (!source.func_76352_a() && (entity = source.func_76364_f()) instanceof EntityLivingBase) {
                this.func_190629_c((EntityLivingBase)entity);
            }
            this.func_184185_a(SoundEvents.field_187603_D, 1.0f, 0.6f + ModRandom.getFloat(0.2f));
            return false;
        }
        return false;
    }

    @Override
    public final void func_70636_d() {
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70636_d();
        Vec3d[] avec3d = new Vec3d[this.hitboxParts.length];
        for (int j = 0; j < this.hitboxParts.length; ++j) {
            avec3d[j] = new Vec3d(this.hitboxParts[j].field_70165_t, this.hitboxParts[j].field_70163_u, this.hitboxParts[j].field_70161_v);
        }
        this.setHitboxPosition((Entity)this.fingers, new Vec3d(0.0, -1.5, 0.0));
        this.setHitboxPosition((Entity)this.behindEye, new Vec3d(-0.5, -0.3, 0.0));
        this.setHitboxPosition((Entity)this.eye, new Vec3d(0.5, -0.3, 0.0));
        this.setHitboxPosition((Entity)this.bottomPalm, new Vec3d(-0.4, 0.7, 0.0));
        this.setHitboxPosition((Entity)this.rightPalm, new Vec3d(0.0, 0.0, -0.7));
        this.setHitboxPosition((Entity)this.leftPalm, new Vec3d(0.0, 0.0, 0.7));
        this.setHitboxPosition((Entity)this.upRightPalm, new Vec3d(0.0, -1.0, -0.7));
        this.setHitboxPosition((Entity)this.upLeftPalm, new Vec3d(0.0, -1.0, 0.7));
        Vec3d fistPos = this.func_174791_d().func_178788_d(ModUtils.yVec(0.5));
        ModUtils.setEntityPosition((Entity)this.fist, fistPos);
        for (int l = 0; l < this.hitboxParts.length; ++l) {
            this.hitboxParts[l].field_70169_q = avec3d[l].field_72450_a;
            this.hitboxParts[l].field_70167_r = avec3d[l].field_72448_b;
            this.hitboxParts[l].field_70166_s = avec3d[l].field_72449_c;
        }
        if (!this.field_70170_p.field_72995_K && this.currentAction != null) {
            this.currentAction.update();
        }
    }

    private void setHitboxPosition(Entity entity, Vec3d offset) {
        Vec3d lookVec = ModUtils.getLookVec(this.getPitch(), this.field_70761_aq);
        Vec3d center = this.func_174791_d().func_178787_e(ModUtils.yVec(1.3));
        Vec3d position = center.func_178788_d(ModUtils.Y_AXIS.func_186678_a(this.fingers.func_174813_aQ().func_72320_b() * 0.5)).func_178787_e(ModUtils.getAxisOffset(lookVec, offset));
        ModUtils.setEntityPosition(entity, position);
    }

    @Override
    public final void func_70071_h_() {
        boolean motionStopped;
        Vec3d vel = ModUtils.getEntityVelocity((Entity)this);
        double speed = vel.func_72433_c();
        super.func_70071_h_();
        boolean bl = motionStopped = this.field_70159_w == 0.0 && vel.field_72450_a != 0.0 || this.field_70181_x == 0.0 && vel.field_72448_b != 0.0 || this.field_70179_y == 0.0 && vel.field_72449_c != 0.0;
        if (motionStopped && this.currentAction != null && this.currentAction.shouldExplodeUponImpact() && !this.field_70170_p.field_72995_K && speed > (double)0.55f) {
            this.onBlockPhysicalImpact(speed);
        }
        if (this.isImmovable()) {
            this.func_70101_b(180.0f, 0.0f);
            this.func_70034_d(180.0f);
        }
    }

    private void onBlockPhysicalImpact(double velocity) {
        Vec3d pos = this.func_174824_e(1.0f);
        DamageSource source = ModDamageSource.builder().directEntity((Entity)this).element(this.getElement()).stoppedByArmorNotShields().type("mm:mobMaelstrom").build();
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
        this.field_70170_p.func_72885_a((Entity)this, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (float)(velocity * 0.75 * this.punchImpactSize), false, flag);
        ModUtils.handleAreaImpact((float)(velocity * this.punchImpactSize), e -> Float.valueOf(this.getAttack()), (Entity)this, pos, source);
    }

    @Override
    protected final void setImmovable(boolean immovable) {
        if (this.isImmovable() && !immovable) {
            this.initGauntletAI();
        } else if (immovable) {
            ModUtils.removeTaskOfType(this.field_70714_bg, AIAerialTimedAttack.class);
            ModUtils.removeTaskOfType(this.field_70714_bg, AiFistWander.class);
        }
        super.setImmovable(immovable);
    }

    @Override
    public final void doRender(RenderManager renderManager, double x, double y, double z, float entityYaw, float partialTicks) {
        if (this.renderLazerPos != null) {
            renderManager.field_78724_e.func_110577_a(RenderDragon.field_110843_g);
            Vec3d interpolatedPos = this.renderLazerPos.func_178788_d(this.prevRenderLazerPos).func_186678_a((double)partialTicks).func_178787_e(this.prevRenderLazerPos);
            RenderUtils.drawBeam(renderManager, this.func_174824_e(1.0f), interpolatedPos, new Vec3d(x, y, z), ModColors.RED, (Entity)this, partialTicks);
        }
        super.doRender(renderManager, x, y, z, entityYaw, partialTicks);
    }

    public final float func_70047_e() {
        return 1.6f;
    }

    @Override
    public final void setPitch(Vec3d look) {
        float prevLook = this.getPitch();
        float newLook = (float)ModUtils.toPitch(look);
        float deltaLook = 5.0f;
        float clampedLook = MathHelper.func_76131_a((float)newLook, (float)(prevLook - deltaLook), (float)(prevLook + deltaLook));
        this.field_70180_af.func_187227_b(LOOK, (Object)Float.valueOf(clampedLook));
    }

    @Override
    public final float getPitch() {
        return this.field_70180_af == null ? 0.0f : ((Float)this.field_70180_af.func_187225_a(LOOK)).floatValue();
    }

    @Override
    public void func_70103_a(byte id) {
        if (id == 39) {
            this.renderLazerPos = null;
        } else if (id == ModUtils.PARTICLE_BYTE) {
            for (int i = 0; i < 5; ++i) {
                Vec3d lookVec = ModUtils.getLookVec(this.getPitch(), this.field_70761_aq);
                Vec3d randOffset = ModUtils.rotateVector2(lookVec, lookVec.func_72431_c(ModUtils.Y_AXIS), ModRandom.range(-70, 70));
                randOffset = ModUtils.rotateVector2(randOffset, lookVec, ModRandom.range(0, 360)).func_186678_a(1.5);
                Vec3d velocity = Vec3d.field_186680_a.func_178788_d(randOffset).func_72432_b().func_186678_a((double)0.15f).func_178787_e(new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y));
                Vec3d particlePos = this.func_174824_e(1.0f).func_178787_e(ModUtils.getAxisOffset(lookVec, new Vec3d(1.0, 0.0, 0.0))).func_178787_e(randOffset);
                ParticleManager.spawnDust(this.field_70170_p, particlePos, ModColors.RED, velocity, ModRandom.range(5, 7));
            }
        } else if (id == ModUtils.SECOND_PARTICLE_BYTE) {
            ModUtils.circleCallback(2.0f, 16, pos -> {
                pos = new Vec3d(pos.field_72450_a, 0.0, pos.field_72448_b).func_178787_e(this.func_174791_d());
                double y = Math.cos(pos.field_72450_a + pos.field_72449_c);
                ParticleManager.spawnSplit(this.field_70170_p, pos.func_178787_e(ModUtils.yVec(y)), ModColors.PURPLE, ModUtils.yVec(-y * 0.1));
            });
        }
        super.func_70103_a(id);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
    }

    public final void func_191986_a(float strafe, float vertical, float forward) {
        ModUtils.aerialTravel((EntityLivingBase)this, strafe, vertical, forward);
    }

    public int func_70070_b() {
        return Math.min(super.func_70070_b() + 60, 200);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LOOK, (Object)Float.valueOf(0.0f));
        super.func_70088_a();
    }

    @Nonnull
    public EntitySenses func_70635_at() {
        return this.senses;
    }

    @Nonnull
    public World func_82194_d() {
        return this.field_70170_p;
    }

    public Entity[] func_70021_al() {
        return this.hitboxParts;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_82196_d(@Nullable EntityLivingBase target, float distanceFactor) {
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public final void func_70091_d(@Nonnull MoverType type, double x, double y, double z) {
        BlockPos blockpos1;
        IBlockState iblockstate1;
        Block block1;
        boolean flag;
        this.field_70170_p.field_72984_F.func_76320_a("move");
        if (this.field_70134_J) {
            this.field_70134_J = false;
            x *= 0.25;
            y *= (double)0.05f;
            z *= 0.25;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        double d2 = x;
        double d3 = y;
        double d4 = z;
        List list1 = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(x, y, z));
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        if (y != 0.0) {
            int l = list1.size();
            for (int k = 0; k < l; ++k) {
                y = ((AxisAlignedBB)list1.get(k)).func_72323_b(this.func_174813_aQ(), y);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
        }
        if (x != 0.0) {
            int l5 = list1.size();
            for (int j5 = 0; j5 < l5; ++j5) {
                x = ((AxisAlignedBB)list1.get(j5)).func_72316_a(this.func_174813_aQ(), x);
            }
            if (x != 0.0) {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
            }
        }
        if (z != 0.0) {
            int i6 = list1.size();
            for (int k5 = 0; k5 < i6; ++k5) {
                z = ((AxisAlignedBB)list1.get(k5)).func_72322_c(this.func_174813_aQ(), z);
            }
            if (z != 0.0) {
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z));
            }
        }
        boolean bl = flag = this.field_70122_E || d3 != y && d3 < 0.0;
        if (this.field_70138_W > 0.0f && flag && (d2 != x || d4 != z)) {
            double d14 = x;
            double d6 = y;
            double d7 = z;
            AxisAlignedBB axisalignedbb1 = this.func_174813_aQ();
            this.func_174826_a(axisalignedbb);
            y = this.field_70138_W;
            List list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(d2, y, d4));
            AxisAlignedBB axisalignedbb2 = this.func_174813_aQ();
            AxisAlignedBB axisalignedbb3 = axisalignedbb2.func_72321_a(d2, 0.0, d4);
            double d8 = y;
            int k1 = list.size();
            for (int j1 = 0; j1 < k1; ++j1) {
                d8 = ((AxisAlignedBB)list.get(j1)).func_72323_b(axisalignedbb3, d8);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, d8, 0.0);
            double d18 = d2;
            int i2 = list.size();
            for (int l1 = 0; l1 < i2; ++l1) {
                d18 = ((AxisAlignedBB)list.get(l1)).func_72316_a(axisalignedbb2, d18);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(d18, 0.0, 0.0);
            double d19 = d4;
            int k2 = list.size();
            for (int j2 = 0; j2 < k2; ++j2) {
                d19 = ((AxisAlignedBB)list.get(j2)).func_72322_c(axisalignedbb2, d19);
            }
            axisalignedbb2 = axisalignedbb2.func_72317_d(0.0, 0.0, d19);
            AxisAlignedBB axisalignedbb4 = this.func_174813_aQ();
            double d20 = y;
            int i3 = list.size();
            for (int l2 = 0; l2 < i3; ++l2) {
                d20 = ((AxisAlignedBB)list.get(l2)).func_72323_b(axisalignedbb4, d20);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, d20, 0.0);
            double d21 = d2;
            int k3 = list.size();
            for (int j3 = 0; j3 < k3; ++j3) {
                d21 = ((AxisAlignedBB)list.get(j3)).func_72316_a(axisalignedbb4, d21);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(d21, 0.0, 0.0);
            double d22 = d4;
            int i4 = list.size();
            for (int l3 = 0; l3 < i4; ++l3) {
                d22 = ((AxisAlignedBB)list.get(l3)).func_72322_c(axisalignedbb4, d22);
            }
            axisalignedbb4 = axisalignedbb4.func_72317_d(0.0, 0.0, d22);
            double d23 = d18 * d18 + d19 * d19;
            double d9 = d21 * d21 + d22 * d22;
            if (d23 > d9) {
                x = d18;
                z = d19;
                y = -d8;
                this.func_174826_a(axisalignedbb2);
            } else {
                x = d21;
                z = d22;
                y = -d20;
                this.func_174826_a(axisalignedbb4);
            }
            int k4 = list.size();
            for (int j4 = 0; j4 < k4; ++j4) {
                y = ((AxisAlignedBB)list.get(j4)).func_72323_b(this.func_174813_aQ(), y);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y, 0.0));
            if (d14 * d14 + d7 * d7 >= x * x + z * z) {
                x = d14;
                y = d6;
                z = d7;
                this.func_174826_a(axisalignedbb1);
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rest");
        this.func_174829_m();
        this.field_70123_F = d2 != x || d4 != z;
        this.field_70124_G = d3 != y;
        this.field_70122_E = this.field_70124_G && d3 < 0.0;
        this.field_70132_H = this.field_70123_F || this.field_70124_G;
        int j6 = MathHelper.func_76128_c((double)this.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int k6 = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(j6, i1, k6);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        if (iblockstate.func_185904_a() == Material.field_151579_a && ((block1 = (iblockstate1 = this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) instanceof BlockFence || block1 instanceof BlockWall || block1 instanceof BlockFenceGate)) {
            iblockstate = iblockstate1;
            blockpos = blockpos1;
        }
        this.func_184231_a(y, this.field_70122_E, iblockstate, blockpos);
        if (d2 != x) {
            this.field_70159_w = 0.0;
        }
        if (d4 != z) {
            this.field_70179_y = 0.0;
        }
        Block block = iblockstate.func_177230_c();
        if (d3 != y) {
            block.func_176216_a(this.field_70170_p, (Entity)this);
        }
        try {
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    @Override
    public final void setRenderDirection(Vec3d dir) {
        this.prevRenderLazerPos = this.renderLazerPos != null ? this.renderLazerPos : dir;
        this.renderLazerPos = dir;
    }

    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        super.func_70037_a(compound);
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(@Nonnull EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@Nonnull EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_GAUNTLET_AMBIENT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_GAUNTLET_HURT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_GAUNTLET_HURT;
    }

    @Override
    public Optional<Vec3d> getTarget() {
        return Optional.ofNullable(this.renderLazerPos);
    }
}

