/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public abstract class EntityTrader
extends EntityLeveledMob
implements IMerchant {
    protected MerchantRecipeList buyingList;
    @Nullable
    protected EntityPlayer buyingPlayer;

    public EntityTrader(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.8f);
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateGround((EntityLiving)this, worldIn);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void populateBuyingList() {
        List<EntityVillager.ITradeList> trades;
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        if ((trades = this.getTrades()) != null) {
            for (EntityVillager.ITradeList list : trades) {
                list.func_190888_a((IMerchant)this, this.buyingList, this.field_70146_Z);
            }
        }
    }

    protected abstract List<EntityVillager.ITradeList> getTrades();

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_70089_S() && !this.isTrading() && !this.func_70631_g_() && !player.func_70093_af() && this.func_70638_az() == null) {
            if (this.buyingList == null) {
                this.populateBuyingList();
            }
            if (hand == EnumHand.MAIN_HAND) {
                player.func_71029_a(StatList.field_188074_H);
            }
            this.onTraderInteract(player);
            if (!this.field_70170_p.field_72995_K && !this.buyingList.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.buyingList.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    protected void onTraderInteract(EntityPlayer player) {
    }

    public boolean isTrading() {
        return this.buyingPlayer != null;
    }

    @Nullable
    public EntityPlayer func_70931_l_() {
        return this.buyingPlayer;
    }

    public void func_70932_a_(@Nullable EntityPlayer player) {
        this.buyingPlayer = player;
    }

    @Nullable
    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        return this.buyingList;
    }

    public void func_70930_a(MerchantRecipeList recipeList) {
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 5));
        }
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public ITextComponent func_145748_c_() {
        Team team = this.func_96124_cp();
        String s = this.func_95999_t();
        if (s != null && !s.isEmpty()) {
            TextComponentString textcomponentstring = new TextComponentString(ScorePlayerTeam.func_96667_a((Team)team, (String)s));
            textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
            textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
            return textcomponentstring;
        }
        if (this.buyingList == null) {
            this.populateBuyingList();
        }
        TextComponentTranslation itextcomponent = new TextComponentTranslation(this.getVillagerName(), new Object[0]);
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        if (team != null) {
            itextcomponent.func_150256_b().func_150238_a(team.func_178775_l());
        }
        return itextcomponent;
    }

    protected abstract String getVillagerName();
}

