/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.ai.AIJumpAtTarget;
import com.barribob.MaelstromMod.entity.ai.EntityAIRangedAttack;
import com.barribob.MaelstromMod.entity.animation.AnimationClip;
import com.barribob.MaelstromMod.entity.animation.StreamAnimation;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.model.ModelMaelstromMage;
import com.barribob.MaelstromMod.entity.projectile.ProjectileHorrorAttack;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import com.barribob.MaelstromMod.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityMaelstromMage
extends EntityMaelstromMob {
    public static final float PROJECTILE_INACCURACY = 6.0f;
    public static final float PROJECTILE_SPEED = 1.2f;

    public EntityMaelstromMage(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.8f);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, new EntityAIRangedAttack<EntityMaelstromMage>(this, 1.0, 50, 20.0f, 15.0f, 0.5f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIJumpAtTarget((EntityLiving)this, 0.4f, 0.5f));
    }

    protected SoundEvent func_184639_G() {
        return SoundsHandler.ENTITY_SHADE_AMBIENT;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsHandler.ENTITY_SHADE_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsHandler.ENTITY_SHADE_DEATH;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.isSwingingArms()) {
            this.prepareShoot();
        }
    }

    protected void prepareShoot() {
        float f = ModRandom.getFloat(0.25f);
        if (this.getElement() != Element.NONE) {
            ParticleManager.spawnEffect(this.field_70170_p, new Vec3d(this.field_70165_t + (double)f, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v + (double)f), this.getElement().particleColor);
        } else {
            ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, new Vec3d(this.field_70165_t + (double)f, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v + (double)f), true);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_72960_a((Entity)this, ModUtils.PARTICLE_BYTE);
        }
    }

    @Override
    public void func_184724_a(boolean swingingArms) {
        super.func_184724_a(swingingArms);
        if (swingingArms) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.getCurrentAnimation().startAnimation();
        } else if (id == ModUtils.PARTICLE_BYTE) {
            if (this.getElement().equals((Object)Element.NONE)) {
                ParticleManager.spawnMaelstromPotionParticle(this.field_70170_p, this.field_70146_Z, this.func_174791_d().func_178787_e(ModRandom.randVec()).func_178787_e(ModUtils.yVec(1.0)), false);
            }
            ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec()).func_178787_e(ModUtils.yVec(1.0)), this.getElement().particleColor);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.field_70170_p.field_72995_K) {
            ProjectileHorrorAttack projectile = new ProjectileHorrorAttack(this.field_70170_p, (EntityLivingBase)this, this.getAttack());
            projectile.field_70163_u = this.field_70163_u + (double)this.func_70047_e() + 1.0;
            double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)0.9f;
            double d1 = target.field_70165_t - this.field_70165_t;
            double d2 = d0 - projectile.field_70163_u;
            double d3 = target.field_70161_v - this.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
            projectile.func_70186_c(d1, d2 + (double)f, d3, 1.2f, 6.0f);
            this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
        ArrayList animation = new ArrayList();
        ArrayList<AnimationClip<ModelMaelstromMage>> leftArmXStream = new ArrayList<AnimationClip<ModelMaelstromMage>>();
        ArrayList<AnimationClip<ModelMaelstromMage>> leftArmZStream = new ArrayList<AnimationClip<ModelMaelstromMage>>();
        ArrayList<AnimationClip<ModelMaelstromMage>> leftForearmXStream = new ArrayList<AnimationClip<ModelMaelstromMage>>();
        ArrayList<AnimationClip<ModelMaelstromMage>> bodyXStream = new ArrayList<AnimationClip<ModelMaelstromMage>>();
        ArrayList<AnimationClip<ModelMaelstromMage>> rightArmXStream = new ArrayList<AnimationClip<ModelMaelstromMage>>();
        BiConsumer<ModelMaelstromMage, Float> leftArmX = (model, f) -> {
            model.leftArm.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelMaelstromMage, Float> leftArmZ = (model, f) -> {
            model.leftArm.field_78808_h = f.floatValue();
        };
        BiConsumer<ModelMaelstromMage, Float> leftForearmX = (model, f) -> {
            model.leftForearm.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelMaelstromMage, Float> bodyX = (model, f) -> {
            model.body.field_78795_f = f.floatValue();
        };
        BiConsumer<ModelMaelstromMage, Float> rightArmX = (model, f) -> {
            model.rightArm.field_78795_f = f.floatValue();
        };
        leftForearmXStream.add(new AnimationClip<ModelMaelstromMage>(10, -40.0f, 0.0f, leftForearmX));
        leftForearmXStream.add(new AnimationClip<ModelMaelstromMage>(12, 0.0f, 0.0f, leftForearmX));
        leftForearmXStream.add(new AnimationClip<ModelMaelstromMage>(6, 0.0f, 0.0f, leftForearmX));
        leftForearmXStream.add(new AnimationClip<ModelMaelstromMage>(6, 0.0f, -40.0f, leftForearmX));
        leftArmXStream.add(new AnimationClip<ModelMaelstromMage>(10, 0.0f, -120.0f, leftArmX));
        leftArmXStream.add(new AnimationClip<ModelMaelstromMage>(12, -120.0f, -120.0f, leftArmX));
        leftArmXStream.add(new AnimationClip<ModelMaelstromMage>(4, -120.0f, 60.0f, leftArmX));
        leftArmXStream.add(new AnimationClip<ModelMaelstromMage>(2, 60.0f, 60.0f, leftArmX));
        leftArmXStream.add(new AnimationClip<ModelMaelstromMage>(6, 60.0f, 0.0f, leftArmX));
        leftArmZStream.add(new AnimationClip<ModelMaelstromMage>(10, 0.0f, -25.0f, leftArmZ));
        leftArmZStream.add(new AnimationClip<ModelMaelstromMage>(12, -25.0f, -25.0f, leftArmZ));
        leftArmZStream.add(new AnimationClip<ModelMaelstromMage>(6, -25.0f, -20.0f, leftArmZ));
        leftArmZStream.add(new AnimationClip<ModelMaelstromMage>(6, -25.0f, 0.0f, leftArmZ));
        bodyXStream.add(new AnimationClip<ModelMaelstromMage>(10, 0.0f, -15.0f, bodyX));
        bodyXStream.add(new AnimationClip<ModelMaelstromMage>(14, -15.0f, -15.0f, bodyX));
        bodyXStream.add(new AnimationClip<ModelMaelstromMage>(6, -15.0f, 15.0f, bodyX));
        bodyXStream.add(new AnimationClip<ModelMaelstromMage>(4, 15.0f, 0.0f, bodyX));
        rightArmXStream.add(new AnimationClip<ModelMaelstromMage>(10, 0.0f, -40.0f, rightArmX));
        rightArmXStream.add(new AnimationClip<ModelMaelstromMage>(12, -40.0f, -40.0f, rightArmX));
        rightArmXStream.add(new AnimationClip<ModelMaelstromMage>(6, -40.0f, 40.0f, rightArmX));
        rightArmXStream.add(new AnimationClip<ModelMaelstromMage>(6, 40.0f, 0.0f, rightArmX));
        animation.add(leftArmXStream);
        animation.add(leftArmZStream);
        animation.add(leftForearmXStream);
        animation.add(bodyXStream);
        animation.add(rightArmXStream);
        this.currentAnimation = new StreamAnimation<ModelMaelstromMage>(animation){

            @Override
            public void setModelRotations(ModelMaelstromMage model, float limbSwing, float limbSwingAmount, float partialTicks) {
                model.leftArm.field_82908_p = (float)Math.cos(Math.toRadians(EntityMaelstromMage.this.field_70173_aa * 4)) * 0.05f;
                model.rightArm.field_82908_p = (float)Math.cos(Math.toRadians(EntityMaelstromMage.this.field_70173_aa * 4)) * 0.05f;
                super.setModelRotations(model, limbSwing, limbSwingAmount, partialTicks);
            }
        };
    }
}

