/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.entities;

import com.barribob.MaelstromMod.entity.animation.Animation;
import com.barribob.MaelstromMod.entity.animation.AnimationNone;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IAnimatedMob;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.ModUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityLeveledFlyingMob
extends EntityFlying
implements IMob,
IRangedAttackMob,
IAnimatedMob,
IElement {
    @SideOnly(value=Side.CLIENT)
    protected Animation currentAnimation;
    private float level;
    protected static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityLeveledMob.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityLeveledFlyingMob(World worldIn) {
        super(worldIn);
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        this.level = level;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.currentAnimation != null && this.func_110143_aJ() > 0.0f) {
            this.currentAnimation.update();
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.field_70173_aa % 20 == 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        }
    }

    public void func_70020_e(NBTTagCompound compound) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        if (compound.func_74764_b("element")) {
            this.setElement(Element.getElementFromId(compound.func_74762_e("element")));
        }
        super.func_70020_e(compound);
    }

    public float getAttack() {
        return ModUtils.getMobDamage(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 0.0, this.func_110138_aP(), this.func_110143_aJ(), this.level, this.getElement());
    }

    @Override
    public Animation getCurrentAnimation() {
        return this.currentAnimation == null ? new AnimationNone() : this.currentAnimation;
    }

    protected float func_70655_b(DamageSource source, float damage) {
        return super.func_70655_b(source, ModUtils.getArmoredDamage(source, damage, this.getLevel(), this.getElement()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 13 && this.currentAnimation == null) {
            this.initAnimation();
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void initAnimation() {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENT, (Object)Element.NONE.id);
    }

    @Override
    public Element getElement() {
        return this.field_70180_af == null ? Element.getElementFromId(Element.NONE.id) : Element.getElementFromId((Integer)this.field_70180_af.func_187225_a(ELEMENT));
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.id);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("element", this.getElement().id);
        super.func_70014_b(compound);
    }
}

