/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.ai;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class ModNodeProcessor
extends NodeProcessor {
    protected float avoidsWater;
    protected EntityLiving currentEntity;

    public void func_186315_a(IBlockAccess sourceIn, EntityLiving mob) {
        super.func_186315_a(sourceIn, mob);
        this.avoidsWater = mob.func_184643_a(PathNodeType.WATER);
    }

    public void func_176163_a() {
        this.field_186326_b.func_184644_a(PathNodeType.WATER, this.avoidsWater);
        super.func_176163_a();
    }

    public PathPoint func_186318_b() {
        int i;
        if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
            i = MathHelper.func_76128_c((double)this.field_186326_b.func_174813_aQ().field_72338_b);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), MathHelper.func_76141_d((float)i), MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
            Block block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            while (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
                blockpos$mutableblockpos.func_181079_c(MathHelper.func_76128_c((double)this.field_186326_b.field_70165_t), ++i, MathHelper.func_76128_c((double)this.field_186326_b.field_70161_v));
                block = this.field_176169_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_177230_c();
            }
            --i;
        } else if (this.field_186326_b.field_70122_E) {
            i = MathHelper.func_76128_c((double)(this.field_186326_b.func_174813_aQ().field_72338_b + 0.5));
        } else {
            BlockPos blockpos = new BlockPos((Entity)this.field_186326_b);
            while ((this.field_176169_a.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a || this.field_176169_a.func_180495_p(blockpos).func_177230_c().func_176205_b(this.field_176169_a, blockpos)) && blockpos.func_177956_o() > 0) {
                blockpos = blockpos.func_177977_b();
            }
            i = blockpos.func_177984_a().func_177956_o();
        }
        BlockPos blockpos2 = new BlockPos((Entity)this.field_186326_b);
        PathNodeType pathnodetype1 = this.getPathNodeType(this.field_186326_b, blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
        if (this.field_186326_b.func_184643_a(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72340_a, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72339_c));
            set.add(new BlockPos(this.field_186326_b.func_174813_aQ().field_72336_d, (double)i, this.field_186326_b.func_174813_aQ().field_72334_f));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, blockpos1);
                if (!(this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f)) continue;
                return this.func_176159_a(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            }
        }
        return this.func_176159_a(blockpos2.func_177958_n(), i, blockpos2.func_177952_p());
    }

    public PathPoint func_186325_a(double x, double y, double z) {
        return this.func_176159_a(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public int func_186320_a(PathPoint[] pathOptions, PathPoint currentPoint, PathPoint targetPoint, float maxDistance) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        PathPoint pathpoint3;
        PathPoint pathpoint2;
        PathPoint pathpoint1;
        double d0;
        PathPoint pathpoint;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c);
        if (this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f) {
            j = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        if ((pathpoint = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0 = ModNodeProcessor.getGroundY(this.field_176169_a, new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c)), EnumFacing.SOUTH)) != null && !pathpoint.field_75842_i && pathpoint.field_186286_l >= 0.0f) {
            pathOptions[i++] = pathpoint;
        }
        if ((pathpoint1 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.WEST)) != null && !pathpoint1.field_75842_i && pathpoint1.field_186286_l >= 0.0f) {
            pathOptions[i++] = pathpoint1;
        }
        if ((pathpoint2 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, j, d0, EnumFacing.EAST)) != null && !pathpoint2.field_75842_i && pathpoint2.field_186286_l >= 0.0f) {
            pathOptions[i++] = pathpoint2;
        }
        if ((pathpoint3 = this.getSafePoint(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint3.field_75842_i && pathpoint3.field_186286_l >= 0.0f) {
            pathOptions[i++] = pathpoint3;
        }
        if (this.func_222860_a(currentPoint, pathpoint1, pathpoint3, pathpoint4 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH))) {
            pathOptions[i++] = pathpoint4;
        }
        if (this.func_222860_a(currentPoint, pathpoint2, pathpoint3, pathpoint5 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, j, d0, EnumFacing.NORTH))) {
            pathOptions[i++] = pathpoint5;
        }
        if (this.func_222860_a(currentPoint, pathpoint1, pathpoint, pathpoint6 = this.getSafePoint(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH))) {
            pathOptions[i++] = pathpoint6;
        }
        if (this.func_222860_a(currentPoint, pathpoint2, pathpoint, pathpoint7 = this.getSafePoint(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, j, d0, EnumFacing.SOUTH))) {
            pathOptions[i++] = pathpoint7;
        }
        return i;
    }

    private boolean func_222860_a(PathPoint p_222860_1_, @Nullable PathPoint p_222860_2_, @Nullable PathPoint p_222860_3_, @Nullable PathPoint p_222860_4_) {
        if (p_222860_4_ != null && p_222860_3_ != null && p_222860_2_ != null) {
            if (p_222860_4_.field_75842_i) {
                return false;
            }
            if (p_222860_3_.field_75837_b <= p_222860_1_.field_75837_b && p_222860_2_.field_75837_b <= p_222860_1_.field_75837_b) {
                return p_222860_4_.field_186286_l >= 0.0f && (p_222860_3_.field_75837_b < p_222860_1_.field_75837_b || p_222860_3_.field_186286_l >= 0.0f) && (p_222860_2_.field_75837_b < p_222860_1_.field_75837_b || p_222860_2_.field_186286_l >= 0.0f);
            }
            return false;
        }
        return false;
    }

    public static double getGroundY(IBlockAccess p_197682_0_, BlockPos pos) {
        return (double)pos.func_177956_o() - (1.0 - p_197682_0_.func_180495_p((BlockPos)pos).func_185900_c((IBlockAccess)p_197682_0_, (BlockPos)pos).field_72337_e);
    }

    @Nullable
    private PathPoint getSafePoint(int x, int y, int z, int stepHeight, double groundYIn, EnumFacing facing) {
        double d3;
        double d2;
        AxisAlignedBB axisalignedbb;
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(x, y, z);
        double d0 = ModNodeProcessor.getGroundY(this.field_176169_a, blockpos);
        if (d0 - groundYIn > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
        float f = this.field_186326_b.func_184643_a(pathnodetype);
        double d1 = (double)this.field_186326_b.field_70130_N / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.func_176159_a(x, y, z);
            pathpoint.field_186287_m = pathnodetype;
            pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if ((pathpoint == null || pathpoint.field_186286_l < 0.0f) && stepHeight > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(x, y + 1, z, stepHeight - 1, groundYIn, facing)) != null && (pathpoint.field_186287_m == PathNodeType.OPEN || pathpoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.field_70130_N < 1.0f && this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb = new AxisAlignedBB((d2 = (double)(x - facing.func_82601_c()) + 0.5) - d1, ModNodeProcessor.getGroundY(this.field_176169_a, new BlockPos(d2, (double)(y + 1), d3 = (double)(z - facing.func_82599_e()) + 0.5)) + 0.001, d3 - d1, d2 + d1, (double)this.field_186326_b.field_70131_O + ModNodeProcessor.getGroundY(this.field_176169_a, new BlockPos(pathpoint.field_75839_a, pathpoint.field_75837_b, pathpoint.field_75838_c)) - 0.002, d3 + d1))) {
            pathpoint = null;
        }
        if (pathnodetype == PathNodeType.WATER && !this.func_186322_e()) {
            if (this.getPathNodeType(this.field_186326_b, x, y - 1, z) != PathNodeType.WATER) {
                return pathpoint;
            }
            while (y > 0) {
                if ((pathnodetype = this.getPathNodeType(this.field_186326_b, x, --y, z)) != PathNodeType.WATER) {
                    return pathpoint;
                }
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = pathnodetype;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, this.field_186326_b.func_184643_a(pathnodetype));
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB((double)x - d1 + 0.5, (double)y + 0.001, (double)z - d1 + 0.5, (double)x + d1 + 0.5, (double)((float)y + this.field_186326_b.field_70131_O), (double)z + d1 + 0.5);
            if (this.field_186326_b.field_70170_p.func_184143_b(axisalignedbb1)) {
                return null;
            }
            if (this.field_186326_b.field_70130_N >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.field_186326_b, x, y - 1, z)) == PathNodeType.BLOCKED) {
                pathpoint = this.func_176159_a(x, y, z);
                pathpoint.field_186287_m = PathNodeType.WALKABLE;
                pathpoint.field_186286_l = Math.max(pathpoint.field_186286_l, f);
                return pathpoint;
            }
            int i = 0;
            int j = y;
            while (pathnodetype == PathNodeType.OPEN) {
                if (--y < 0) {
                    PathPoint pathpoint2 = this.func_176159_a(x, j, z);
                    pathpoint2.field_186287_m = PathNodeType.BLOCKED;
                    pathpoint2.field_186286_l = -1.0f;
                    return pathpoint2;
                }
                PathPoint pathpoint1 = this.func_176159_a(x, y, z);
                if (i++ >= this.field_186326_b.func_82143_as()) {
                    pathpoint1.field_186287_m = PathNodeType.BLOCKED;
                    pathpoint1.field_186286_l = -1.0f;
                    return pathpoint1;
                }
                pathnodetype = this.getPathNodeType(this.field_186326_b, x, y, z);
                f = this.field_186326_b.func_184643_a(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = pathpoint1;
                    pathpoint1.field_186287_m = pathnodetype;
                    pathpoint1.field_186286_l = Math.max(pathpoint1.field_186286_l, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                pathpoint1.field_186287_m = PathNodeType.BLOCKED;
                pathpoint1.field_186286_l = -1.0f;
                return pathpoint1;
            }
        }
        return pathpoint;
    }

    public PathNodeType func_186319_a(IBlockAccess blockaccessIn, int x, int y, int z, EntityLiving entitylivingIn, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        double d0 = (double)entitylivingIn.field_70130_N / 2.0;
        BlockPos blockpos = new BlockPos((Entity)entitylivingIn);
        this.currentEntity = entitylivingIn;
        pathnodetype = this.getPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, true, true, enumset, pathnodetype, blockpos);
        this.currentEntity = entitylivingIn;
        if (enumset.contains(PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype1 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype2 : enumset) {
            if (entitylivingIn.func_184643_a(pathnodetype2) < 0.0f) {
                return pathnodetype2;
            }
            if (!(entitylivingIn.func_184643_a(pathnodetype2) >= entitylivingIn.func_184643_a(pathnodetype1))) continue;
            pathnodetype1 = pathnodetype2;
        }
        if (pathnodetype == PathNodeType.OPEN && entitylivingIn.func_184643_a(pathnodetype1) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype1;
    }

    public PathNodeType getPathNodeType(IBlockAccess p_193577_1_, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> nodeTypeEnum, PathNodeType nodeType, BlockPos pos) {
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int l = i + x;
                    int i1 = j + y;
                    int j1 = k + z;
                    PathNodeType pathnodetype = this.func_186330_a(p_193577_1_, l, i1, j1);
                    pathnodetype = this.func_215744_a(p_193577_1_, true, true, pos, pathnodetype);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = pathnodetype;
                    }
                    nodeTypeEnum.add(pathnodetype);
                }
            }
        }
        return nodeType;
    }

    protected PathNodeType func_215744_a(IBlockAccess blockAccessIn, boolean p_215744_2_, boolean p_215744_3_, BlockPos p_215744_4_, PathNodeType p_215744_5_) {
        if (p_215744_5_ == PathNodeType.DOOR_WOOD_CLOSED) {
            p_215744_5_ = PathNodeType.WALKABLE;
        }
        if (p_215744_5_ == PathNodeType.RAIL && !(blockAccessIn.func_180495_p(p_215744_4_).func_177230_c() instanceof BlockRailBase) && !(blockAccessIn.func_180495_p(p_215744_4_.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
            p_215744_5_ = PathNodeType.FENCE;
        }
        return p_215744_5_;
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, BlockPos pos) {
        return this.getPathNodeType(entitylivingIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private PathNodeType getPathNodeType(EntityLiving entitylivingIn, int x, int y, int z) {
        return this.func_186319_a(this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, true, true);
    }

    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
        PathNodeType pathnodetype = this.getPathNodeTypeRaw(blockaccessIn, x, y, z);
        if (pathnodetype == PathNodeType.OPEN && y >= 1) {
            Block block = blockaccessIn.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(blockaccessIn, x, y - 1, z);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.field_189877_df) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_OTHER) {
                pathnodetype = PathNodeType.DAMAGE_OTHER;
            }
        }
        pathnodetype = this.checkNeighborBlocks(blockaccessIn, x, y, z, pathnodetype);
        return pathnodetype;
    }

    public PathNodeType checkNeighborBlocks(IBlockAccess blockaccessIn, int x, int y, int z, PathNodeType nodeType) {
        if (nodeType == PathNodeType.WALKABLE) {
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    IBlockState state = blockaccessIn.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(i + x, y, j + z));
                    Block block = state.func_177230_c();
                    PathNodeType type = block.getAiPathNodeType(state, blockaccessIn, (BlockPos)blockpos$pooledmutableblockpos);
                    if (block == Blocks.field_150434_aF || type == PathNodeType.DAMAGE_CACTUS) {
                        nodeType = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block != Blocks.field_150480_ab && type != PathNodeType.DAMAGE_FIRE) continue;
                    nodeType = PathNodeType.DANGER_FIRE;
                }
            }
        }
        return nodeType;
    }

    protected PathNodeType getPathNodeTypeRaw(IBlockAccess blockaccessIn, int x, int y, int z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        IBlockState blockstate = blockaccessIn.func_180495_p(blockpos);
        PathNodeType type = blockstate.func_177230_c().getAiPathNodeType(blockstate, blockaccessIn, blockpos);
        if (type != null) {
            return type;
        }
        Block block = blockstate.func_177230_c();
        Material material = blockstate.func_185904_a();
        if (material == Material.field_151579_a) {
            return PathNodeType.OPEN;
        }
        if (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi) {
            if (block == Blocks.field_150480_ab) {
                return PathNodeType.DAMAGE_FIRE;
            }
            if (block == Blocks.field_150434_aF) {
                return PathNodeType.DAMAGE_CACTUS;
            }
            if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)blockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_WOOD_CLOSED;
            }
            if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)blockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_IRON_CLOSED;
            }
            if (block instanceof BlockDoor && ((Boolean)blockstate.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                return PathNodeType.DOOR_OPEN;
            }
            if (block instanceof BlockRailBase) {
                return PathNodeType.RAIL;
            }
            if (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)blockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue())) {
                if (material == Material.field_151586_h) {
                    return PathNodeType.WATER;
                }
                if (material == Material.field_151587_i) {
                    return PathNodeType.LAVA;
                }
                return block.func_176205_b(blockaccessIn, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
            }
            return PathNodeType.FENCE;
        }
        return PathNodeType.TRAPDOOR;
    }
}

