/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util;

import amerifrance.guideapi.ConfigHandler;
import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideItem;
import amerifrance.guideapi.api.IGuideLinked;
import amerifrance.guideapi.api.IInfoRenderer;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.util.TextHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="guideapi")
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            NBTTagCompound tag = EventHandler.getModTag(player, "guideapi");
            if (ConfigHandler.canSpawnWithBooks) {
                for (Book book : GuideAPI.getBooks().values()) {
                    if (!ConfigHandler.SPAWN_BOOKS.getOrDefault(book, false).booleanValue() || tag.func_74767_n("hasInitial" + book.getTitle())) continue;
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)GuideAPI.getStackFromBook(book));
                    tag.func_74757_a("hasInitial" + book.getTitle(), true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderOverlay(RenderGameOverlayEvent.Pre event) {
        Multimap<Class<? extends Block>, IInfoRenderer> bookRenderers;
        IGuideLinked linked;
        ResourceLocation entryKey;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        RayTraceResult rayTrace = Minecraft.func_71410_x().field_71476_x;
        if (rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack held = ItemStack.field_190927_a;
        Book book = null;
        for (EnumHand hand : EnumHand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (!(heldStack.func_77973_b() instanceof IGuideItem)) continue;
            held = heldStack;
            book = ((IGuideItem)heldStack.func_77973_b()).getBook(heldStack);
            break;
        }
        if (book == null) {
            return;
        }
        IBlockState state = world.func_180495_p(rayTrace.func_178782_a());
        String linkedEntry = null;
        if (state.func_177230_c() instanceof IGuideLinked && (entryKey = (linked = (IGuideLinked)state.func_177230_c()).getLinkedEntry((World)world, rayTrace.func_178782_a(), (EntityPlayer)player, held)) != null) {
            for (CategoryAbstract category : book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                linkedEntry = category.getEntry(entryKey).getLocalizedName();
                break;
            }
        }
        if (!Strings.isNullOrEmpty(linkedEntry)) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int drawX = scaledResolution.func_78326_a() / 2 + 10;
            int drawY = scaledResolution.func_78328_b() / 2 - 8;
            Minecraft.func_71410_x().func_175599_af().func_175042_a(held, drawX, drawY);
            fontRenderer.func_175063_a(TextFormatting.WHITE + linkedEntry, (float)(drawX += 20), (float)(drawY -= 2), 0);
            fontRenderer.func_175063_a(TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString() + TextHelper.localize("text.linked.open", new Object[0]), (float)drawX, (float)(drawY + 12), 0);
        }
        if (state.func_177230_c() instanceof IInfoRenderer.Block) {
            IInfoRenderer infoRenderer = ((IInfoRenderer.Block)state.func_177230_c()).getInfoRenderer(book, (World)world, rayTrace.func_178782_a(), state, rayTrace, (EntityPlayer)player);
            if (book == ((IInfoRenderer.Block)state.func_177230_c()).getBook() && infoRenderer != null) {
                infoRenderer.drawInformation(book, (World)world, rayTrace.func_178782_a(), state, rayTrace, (EntityPlayer)player);
            }
        }
        if ((bookRenderers = GuideAPI.getInfoRenderers().get(book)) == null) {
            return;
        }
        Collection renderers = bookRenderers.get(state.func_177230_c().getClass());
        for (IInfoRenderer renderer : renderers) {
            renderer.drawInformation(book, (World)world, rayTrace.func_178782_a(), state, rayTrace, (EntityPlayer)player);
        }
    }

    public static NBTTagCompound getModTag(EntityPlayer player, String modName) {
        NBTTagCompound modTag;
        NBTTagCompound persistTag;
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("PlayerPersisted")) {
            persistTag = tag.func_74775_l("PlayerPersisted");
        } else {
            persistTag = new NBTTagCompound();
            tag.func_74782_a("PlayerPersisted", (NBTBase)persistTag);
        }
        if (persistTag.func_74764_b(modName)) {
            modTag = persistTag.func_74775_l(modName);
        } else {
            modTag = new NBTTagCompound();
            persistTag.func_74782_a(modName, (NBTBase)modTag);
        }
        return modTag;
    }
}

